/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;

@Schema(name="OrgPurseValidateResponse", title="OrgPurseValidateResponse \u8c03\u5ea6\u524d\u7684\u8054\u52a8\u503c\u6838\u5bf9\u7ed3\u679c")
public class OrgPurseValidateResponse
extends ResponseAbstract {
    @Schema(name="orgPurseItems", title="\u5404\u4f01\u4e1a\u7684\u8c03\u5ea6\u524d\u7684\u8054\u52a8\u503c\u6838\u5bf9\u7ed3\u679c")
    private final Collection<OrgPurseItemResponse> orgPurseItems;

    public boolean IsDispatchable(String organizationId) {
        if (organizationId == null) {
            return false;
        }
        return this.getOrgPurseItems() != null && !this.getOrgPurseItems().stream().allMatch(ii -> ii.getOrganizationId().equalsIgnoreCase(organizationId) && !ii.isDispatchable());
    }

    public OrgPurseValidateResponse(Collection<OrgPurseItemResponse> orgPurseItems) {
        this.orgPurseItems = orgPurseItems;
    }

    public static OrgPurseValidateResponse create(Collection<OrgPurseItemResponse> orgPurseItems) {
        return new OrgPurseValidateResponse(orgPurseItems);
    }

    public Collection<OrgPurseItemResponse> getOrgPurseItems() {
        return this.orgPurseItems;
    }

    @Schema(name="OrgPurseItemResponse", title="\u4f01\u4e1a\u7684\u8c03\u5ea6\u60c5\u51b5\u53ca\u8054\u52a8\u503c\u60c5\u51b5")
    public static class OrgPurseItemResponse
    extends ResponseAbstract {
        @Schema(name="organizationId", title="\u7ec4\u7ec7id")
        private final String organizationId;
        @Schema(name="dispatchable", title="\u8be5\u503c\u4e3atrue\u7684\u65f6\u5019, \u8be5\u4f01\u4e1a\u7684\u4fdd\u5b89\u4eba\u5458\u624d\u53ef\u4ee5\u88ab\u8c03\u5ea6; \u4e3afalse\u7684\u65f6\u5019, \u8be5\u4f01\u4e1a\u7684\u4fdd\u5b89\u4eba\u5458\u4e0d\u53ef\u88ab\u8c03\u5ea6")
        private final boolean dispatchable;

        public OrgPurseItemResponse(String organizationId, boolean dispatchable) {
            this.organizationId = organizationId;
            this.dispatchable = dispatchable;
        }

        public static OrgPurseItemResponse create(String organizationId, boolean dispatchable) {
            return new OrgPurseItemResponse(organizationId, dispatchable);
        }

        public String getOrganizationId() {
            return this.organizationId;
        }

        public boolean isDispatchable() {
            return this.dispatchable;
        }
    }
}

