/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.jdks.requests.RequestAbstract;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class PoliceIncidentStatisticsRequest
extends RequestAbstract {
    private boolean fromRedis;
    private boolean fromSocketRequest;
    private Collection<String> superviseDepartIds;

    public static PoliceIncidentStatisticsRequest create(boolean fromRedis) {
        PoliceIncidentStatisticsRequest request = new PoliceIncidentStatisticsRequest();
        request.setFromRedis(fromRedis);
        return request;
    }

    public static PoliceIncidentStatisticsRequest create(boolean fromSocketRequest, String[] superviseDepartIds) {
        PoliceIncidentStatisticsRequest request = new PoliceIncidentStatisticsRequest();
        request.setFromRedis(false);
        request.setFromSocketRequest(fromSocketRequest);
        if (superviseDepartIds == null) {
            request.setSuperviseDepartIds(new ArrayList<String>());
        } else {
            request.setSuperviseDepartIds(Arrays.stream(superviseDepartIds).toList());
        }
        return request;
    }

    public boolean isFromRedis() {
        return this.fromRedis;
    }

    public boolean isFromSocketRequest() {
        return this.fromSocketRequest;
    }

    public Collection<String> getSuperviseDepartIds() {
        return this.superviseDepartIds;
    }

    public void setFromRedis(boolean fromRedis) {
        this.fromRedis = fromRedis;
    }

    public void setFromSocketRequest(boolean fromSocketRequest) {
        this.fromSocketRequest = fromSocketRequest;
    }

    public void setSuperviseDepartIds(Collection<String> superviseDepartIds) {
        this.superviseDepartIds = superviseDepartIds;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PoliceIncidentStatisticsRequest)) {
            return false;
        }
        PoliceIncidentStatisticsRequest other = (PoliceIncidentStatisticsRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFromRedis() != other.isFromRedis()) {
            return false;
        }
        if (this.isFromSocketRequest() != other.isFromSocketRequest()) {
            return false;
        }
        Collection<String> this$superviseDepartIds = this.getSuperviseDepartIds();
        Collection<String> other$superviseDepartIds = other.getSuperviseDepartIds();
        return !(this$superviseDepartIds == null ? other$superviseDepartIds != null : !((Object)this$superviseDepartIds).equals(other$superviseDepartIds));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PoliceIncidentStatisticsRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFromRedis() ? 79 : 97);
        result = result * 59 + (this.isFromSocketRequest() ? 79 : 97);
        Collection<String> $superviseDepartIds = this.getSuperviseDepartIds();
        result = result * 59 + ($superviseDepartIds == null ? 43 : ((Object)$superviseDepartIds).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "PoliceIncidentStatisticsRequest(fromRedis=" + this.isFromRedis() + ", fromSocketRequest=" + this.isFromSocketRequest() + ", superviseDepartIds=" + this.getSuperviseDepartIds() + ")";
    }
}

