/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class RollCallPlanScheduledResponse
extends ResponseAbstract {
    private long id;
    private int repetitiveRule;
    private String superviseDepartId;
    private Collection<String> stationTypes;
    private Collection<Integer> periodsOfTimes;
    private String actionOrgInstitutional;
    private String actionOrganizationId;
    private String actionOrganizationName;
    private String actionEmployeeId;
    private String actionEmployeeName;

    public RollCallPlanScheduledResponse() {
    }

    public Collection<Integer> getMatchedScheduledPlanTimes(int hourOfNow, Map<Long, Collection<Integer>> processedHourOfDayRollCallMap) {
        if (CollectionUtils.isEmpty(this.getPeriodsOfTimes())) {
            return Collections.EMPTY_LIST;
        }
        Collection selectedPeriodOfTimes = this.periodsOfTimes.stream().filter(ix -> {
            boolean flag;
            boolean bl = flag = ix <= hourOfNow;
            if (!flag) {
                return false;
            }
            Collection processedHourOfDay = (Collection)processedHourOfDayRollCallMap.get(this.getId());
            if (CollectionUtils.isEmpty((Collection)processedHourOfDay)) {
                return true;
            }
            return processedHourOfDay.stream().anyMatch(dd -> dd == ix);
        }).collect(Collectors.toList());
        return selectedPeriodOfTimes;
    }

    public RollCallPlanScheduledResponse(long id, int repetitiveRule, String superviseDepartId, Collection<String> stationTypes, Collection<Time> periodsOfTimes, String actionOrganizationId, String actionOrgInstitutional, String actionOrganizationName, String actionEmployeeId, String actionEmployeeName) {
        this.id = id;
        this.repetitiveRule = repetitiveRule;
        this.superviseDepartId = superviseDepartId;
        this.stationTypes = stationTypes;
        this.actionOrganizationId = actionOrganizationId;
        this.actionOrganizationName = actionOrganizationName;
        this.actionEmployeeId = actionEmployeeId;
        this.actionEmployeeName = actionEmployeeName;
        this.actionOrgInstitutional = actionOrgInstitutional;
        if (!CollectionUtils.isEmpty(periodsOfTimes)) {
            SimpleDateFormat hourDateFormat = new SimpleDateFormat("HHmm");
            this.periodsOfTimes = periodsOfTimes.stream().map(ii -> Integer.parseInt(hourDateFormat.format((Date)ii))).collect(Collectors.toList());
        } else {
            this.periodsOfTimes = new HashSet<Integer>();
        }
    }

    public static RollCallPlanScheduledResponse create(long id, int repetitiveRule, String superviseDepartId, Collection<String> stationTypes, Collection<Time> periodsOfTimes, String actionOrganizationId, String actionOrgInstitutional, String actionOrganizationName, String actionEmployeeId, String actionEmployeeName) {
        return new RollCallPlanScheduledResponse(id, repetitiveRule, superviseDepartId, stationTypes, periodsOfTimes, actionOrganizationId, actionOrgInstitutional, actionOrganizationName, actionEmployeeId, actionEmployeeName);
    }

    public long getId() {
        return this.id;
    }

    public int getRepetitiveRule() {
        return this.repetitiveRule;
    }

    public String getSuperviseDepartId() {
        return this.superviseDepartId;
    }

    public Collection<String> getStationTypes() {
        return this.stationTypes;
    }

    public Collection<Integer> getPeriodsOfTimes() {
        return this.periodsOfTimes;
    }

    public String getActionOrgInstitutional() {
        return this.actionOrgInstitutional;
    }

    public String getActionOrganizationId() {
        return this.actionOrganizationId;
    }

    public String getActionOrganizationName() {
        return this.actionOrganizationName;
    }

    public String getActionEmployeeId() {
        return this.actionEmployeeId;
    }

    public String getActionEmployeeName() {
        return this.actionEmployeeName;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setRepetitiveRule(int repetitiveRule) {
        this.repetitiveRule = repetitiveRule;
    }

    public void setSuperviseDepartId(String superviseDepartId) {
        this.superviseDepartId = superviseDepartId;
    }

    public void setStationTypes(Collection<String> stationTypes) {
        this.stationTypes = stationTypes;
    }

    public void setPeriodsOfTimes(Collection<Integer> periodsOfTimes) {
        this.periodsOfTimes = periodsOfTimes;
    }

    public void setActionOrgInstitutional(String actionOrgInstitutional) {
        this.actionOrgInstitutional = actionOrgInstitutional;
    }

    public void setActionOrganizationId(String actionOrganizationId) {
        this.actionOrganizationId = actionOrganizationId;
    }

    public void setActionOrganizationName(String actionOrganizationName) {
        this.actionOrganizationName = actionOrganizationName;
    }

    public void setActionEmployeeId(String actionEmployeeId) {
        this.actionEmployeeId = actionEmployeeId;
    }

    public void setActionEmployeeName(String actionEmployeeName) {
        this.actionEmployeeName = actionEmployeeName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RollCallPlanScheduledResponse)) {
            return false;
        }
        RollCallPlanScheduledResponse other = (RollCallPlanScheduledResponse)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getRepetitiveRule() != other.getRepetitiveRule()) {
            return false;
        }
        String this$superviseDepartId = this.getSuperviseDepartId();
        String other$superviseDepartId = other.getSuperviseDepartId();
        if (this$superviseDepartId == null ? other$superviseDepartId != null : !this$superviseDepartId.equals(other$superviseDepartId)) {
            return false;
        }
        Collection<String> this$stationTypes = this.getStationTypes();
        Collection<String> other$stationTypes = other.getStationTypes();
        if (this$stationTypes == null ? other$stationTypes != null : !((Object)this$stationTypes).equals(other$stationTypes)) {
            return false;
        }
        Collection<Integer> this$periodsOfTimes = this.getPeriodsOfTimes();
        Collection<Integer> other$periodsOfTimes = other.getPeriodsOfTimes();
        if (this$periodsOfTimes == null ? other$periodsOfTimes != null : !((Object)this$periodsOfTimes).equals(other$periodsOfTimes)) {
            return false;
        }
        String this$actionOrgInstitutional = this.getActionOrgInstitutional();
        String other$actionOrgInstitutional = other.getActionOrgInstitutional();
        if (this$actionOrgInstitutional == null ? other$actionOrgInstitutional != null : !this$actionOrgInstitutional.equals(other$actionOrgInstitutional)) {
            return false;
        }
        String this$actionOrganizationId = this.getActionOrganizationId();
        String other$actionOrganizationId = other.getActionOrganizationId();
        if (this$actionOrganizationId == null ? other$actionOrganizationId != null : !this$actionOrganizationId.equals(other$actionOrganizationId)) {
            return false;
        }
        String this$actionOrganizationName = this.getActionOrganizationName();
        String other$actionOrganizationName = other.getActionOrganizationName();
        if (this$actionOrganizationName == null ? other$actionOrganizationName != null : !this$actionOrganizationName.equals(other$actionOrganizationName)) {
            return false;
        }
        String this$actionEmployeeId = this.getActionEmployeeId();
        String other$actionEmployeeId = other.getActionEmployeeId();
        if (this$actionEmployeeId == null ? other$actionEmployeeId != null : !this$actionEmployeeId.equals(other$actionEmployeeId)) {
            return false;
        }
        String this$actionEmployeeName = this.getActionEmployeeName();
        String other$actionEmployeeName = other.getActionEmployeeName();
        return !(this$actionEmployeeName == null ? other$actionEmployeeName != null : !this$actionEmployeeName.equals(other$actionEmployeeName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RollCallPlanScheduledResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        result = result * 59 + this.getRepetitiveRule();
        String $superviseDepartId = this.getSuperviseDepartId();
        result = result * 59 + ($superviseDepartId == null ? 43 : $superviseDepartId.hashCode());
        Collection<String> $stationTypes = this.getStationTypes();
        result = result * 59 + ($stationTypes == null ? 43 : ((Object)$stationTypes).hashCode());
        Collection<Integer> $periodsOfTimes = this.getPeriodsOfTimes();
        result = result * 59 + ($periodsOfTimes == null ? 43 : ((Object)$periodsOfTimes).hashCode());
        String $actionOrgInstitutional = this.getActionOrgInstitutional();
        result = result * 59 + ($actionOrgInstitutional == null ? 43 : $actionOrgInstitutional.hashCode());
        String $actionOrganizationId = this.getActionOrganizationId();
        result = result * 59 + ($actionOrganizationId == null ? 43 : $actionOrganizationId.hashCode());
        String $actionOrganizationName = this.getActionOrganizationName();
        result = result * 59 + ($actionOrganizationName == null ? 43 : $actionOrganizationName.hashCode());
        String $actionEmployeeId = this.getActionEmployeeId();
        result = result * 59 + ($actionEmployeeId == null ? 43 : $actionEmployeeId.hashCode());
        String $actionEmployeeName = this.getActionEmployeeName();
        result = result * 59 + ($actionEmployeeName == null ? 43 : $actionEmployeeName.hashCode());
        return result;
    }

    public String toString() {
        return "RollCallPlanScheduledResponse(id=" + this.getId() + ", repetitiveRule=" + this.getRepetitiveRule() + ", superviseDepartId=" + this.getSuperviseDepartId() + ", stationTypes=" + this.getStationTypes() + ", periodsOfTimes=" + this.getPeriodsOfTimes() + ", actionOrgInstitutional=" + this.getActionOrgInstitutional() + ", actionOrganizationId=" + this.getActionOrganizationId() + ", actionOrganizationName=" + this.getActionOrganizationName() + ", actionEmployeeId=" + this.getActionEmployeeId() + ", actionEmployeeName=" + this.getActionEmployeeName() + ")";
    }
}

