/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;

@Schema(name="RollCallPlanResponse", title="RollCallPlanResponse \u70b9\u540d\u8f6e\u6362\u4fe1\u606f")
public class RollCallPlanResponse
extends ResponseAbstract {
    private final String id;
    private final String name;
    private final String superviseDepartName;
    private final Collection<String> stationTypes;
    private final String beginTime;
    private final String endTime;
    private final int countOfInstances;

    public RollCallPlanResponse(Long id, String name, String superviseDepartName, Collection<String> stationTypes, Date beginTime, Date endTime, int countOfInstances) {
        this.id = String.valueOf(id);
        this.name = name;
        this.superviseDepartName = superviseDepartName;
        this.stationTypes = stationTypes;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.beginTime = dateFormat.format(beginTime);
        this.endTime = dateFormat.format(endTime);
        this.countOfInstances = countOfInstances;
    }

    public static RollCallPlanResponse create(Long id, String name, String superviseDepartName, Collection<String> stationTypes, Date beginTime, Date endTime, int countOfInstances) {
        return new RollCallPlanResponse(id, name, superviseDepartName, stationTypes, beginTime, endTime, countOfInstances);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getSuperviseDepartName() {
        return this.superviseDepartName;
    }

    public Collection<String> getStationTypes() {
        return this.stationTypes;
    }

    public String getBeginTime() {
        return this.beginTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public int getCountOfInstances() {
        return this.countOfInstances;
    }
}

