/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.ExamType;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

@Schema(name="ExamSiteRoomOverviewResponse", title="\u8003\u573a\u4fe1\u606f")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ExamSiteRoomDetailResponse
extends ResponseAbstract {
    @Schema(name="id", title="\u8003\u573aId")
    private final String id;
    @Schema(name="name", title="\u8003\u573a\u540d\u79f0")
    private final String name;
    @Schema(name="examSiteName", title="\u8003\u8bd5\u70b9")
    private final String examSiteName;
    @Schema(name="examSiteId", title="\u8003\u8bd5\u70b9Id")
    private final String examSiteId;
    @Schema(name="companyName", title="\u6240\u5728\u516c\u53f8")
    private final String companyName;
    @Schema(name="organizationId", title="\u7ec4\u7ec7Id")
    private final String organizationId;
    @Schema(name="countOfTeachers", title="\u76d1\u8003\u8001\u5e08\u6570\u91cf")
    private final int countOfTeachers;
    @Schema(name="examType", title="\u8003\u8bd5\u7c7b\u578b")
    private final String examType;
    @Schema(name="examTimeScope", title="\u5f53\u524d\u8003\u8bd5\u65f6\u95f4")
    private final String examTimeScope;
    @Schema(name="examId", title="\u5f53\u524d\u8003\u8bd5Id")
    private final String examId;
    @Schema(name="examName", title="\u5f53\u524d\u8003\u8bd5\u540d\u79f0")
    private final String examName;
    @Schema(name="capacityOfPerson", title="\u5bb9\u7eb3\u7684\u4eba\u5458\u6570\u91cf")
    private final int capacityOfPerson;
    @Schema(name="scopeRange", title="\u6709\u6548\u8303\u56f4")
    private final String scopeRange;
    @Schema(name="latitude", title="\u8003\u573a\u6240\u5728y\u8f74\u5750\u6807")
    private final Double latitude;
    @Schema(name="longitude", title="\u8003\u573a\u6240\u5728x\u8f74\u5750\u6807")
    private final Double longitude;
    @Schema(name="hasVideo", title="\u662f\u5426\u542b\u6709\u89c6\u9891\u76d1\u63a7; \u6709\u7684\u8bdd, \u8df3\u8f6c\u5230\u89c6\u9891\u76d1\u63a7\u7684\u9875\u9762")
    private final boolean hasVideo;

    public ExamSiteRoomDetailResponse(String id, String name, String examSiteId, String examSiteName, String companyName, String organizationId, int countOfTeachers, ExamType examType, LocalDateTime examBeginTime, LocalDateTime examEndTime, String examId, String examName, int capacityOfPerson, String scopeRange, Double latitude, Double longitude, Boolean hasVideo) {
        this.id = id;
        this.name = name;
        this.examSiteId = examSiteId;
        this.examSiteName = examSiteName;
        this.companyName = companyName;
        this.organizationId = organizationId;
        this.countOfTeachers = countOfTeachers;
        this.examType = examType == null ? "" : examType.getTypeName();
        if (examBeginTime != null && examEndTime != null) {
            DateTimeFormatter fromTimeFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
            DateTimeFormatter endTimeFormat = DateTimeFormatter.ofPattern("HH:mm");
            this.examTimeScope = String.format("%s - %s", examBeginTime.format(fromTimeFormat), examEndTime.format(endTimeFormat));
        } else {
            this.examTimeScope = "";
        }
        this.examName = examName;
        this.examId = examId;
        this.capacityOfPerson = capacityOfPerson;
        this.scopeRange = scopeRange;
        this.longitude = longitude;
        this.latitude = latitude;
        this.hasVideo = hasVideo == null ? false : hasVideo;
    }

    public static ExamSiteRoomDetailResponse create(String id, String name, String examSiteId, String examSiteName, String companyName, String organizationId, int countOfTeachers, ExamType examType, LocalDateTime examBeginTime, LocalDateTime examEndTime, String examId, String examName, int capacityOfPerson, String scopeRange, Double latitude, Double longitude, Boolean hasVideo) {
        return new ExamSiteRoomDetailResponse(id, name, examSiteId, examSiteName, companyName, organizationId, countOfTeachers, examType, examBeginTime, examEndTime, examId, examName, capacityOfPerson, scopeRange, latitude, longitude, hasVideo);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getExamSiteName() {
        return this.examSiteName;
    }

    public String getExamSiteId() {
        return this.examSiteId;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public int getCountOfTeachers() {
        return this.countOfTeachers;
    }

    public String getExamType() {
        return this.examType;
    }

    public String getExamTimeScope() {
        return this.examTimeScope;
    }

    public String getExamId() {
        return this.examId;
    }

    public String getExamName() {
        return this.examName;
    }

    public int getCapacityOfPerson() {
        return this.capacityOfPerson;
    }

    public String getScopeRange() {
        return this.scopeRange;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public boolean isHasVideo() {
        return this.hasVideo;
    }
}

