/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.utils.StringUtil;
import com.bcxin.tenant.open.jdks.requests.RequestAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.collections4.CollectionUtils;

@Schema(name="OrgPursePointRequest", title="OrgPursePointRequest \u8c03\u5ea6\u524d\u7684\u4f01\u4e1a\u7ec4\u7ec7\u9a8c\u8bc1")
public class OrgPursePointRequest
extends RequestAbstract {
    @Schema(name="organizationIds", title="\u88ab\u8c03\u5ea6\u4eba\u6240\u5728\u7684\u4f01\u4e1aid\u96c6\u5408")
    private Collection<String> organizationIds;

    public static OrgPursePointRequest create(Collection<String> organizationIds) {
        OrgPursePointRequest request = new OrgPursePointRequest();
        request.setOrganizationIds(organizationIds);
        return request;
    }

    public static OrgPursePointRequest create(String organizationId) {
        return OrgPursePointRequest.create(Collections.singleton(organizationId));
    }

    public boolean matched(String organizationId) {
        if (StringUtil.isEmpty((String)organizationId)) {
            return false;
        }
        if (CollectionUtils.isEmpty(this.getOrganizationIds())) {
            return false;
        }
        return this.getOrganizationIds().contains(organizationId);
    }

    public Collection<String> getOrganizationIds() {
        return this.organizationIds;
    }

    public void setOrganizationIds(Collection<String> organizationIds) {
        this.organizationIds = organizationIds;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrgPursePointRequest)) {
            return false;
        }
        OrgPursePointRequest other = (OrgPursePointRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Collection<String> this$organizationIds = this.getOrganizationIds();
        Collection<String> other$organizationIds = other.getOrganizationIds();
        return !(this$organizationIds == null ? other$organizationIds != null : !((Object)this$organizationIds).equals(other$organizationIds));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OrgPursePointRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Collection<String> $organizationIds = this.getOrganizationIds();
        result = result * 59 + ($organizationIds == null ? 43 : ((Object)$organizationIds).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "OrgPursePointRequest(organizationIds=" + this.getOrganizationIds() + ")";
    }
}

