package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RollCallStatus;
import com.bcxin.tenant.open.infrastructures.enums.RollCallType;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collection;

@Schema(name = "RollCallEmployeeSearchResponse",title = "我的被点名记录")
@Getter
public class RollCallEmployeeSearchResponse extends ResponseAbstract {
    @Schema(name = "rollCallId", title = "点名Id")
    private final String rollCallId;

    @Schema(name = "callStatusLabel", title = "点名类型/状态的中文描述")
    private final String callStatusLabel;

    @Schema(name = "callTypeLabel", title = "点名类型/状态的中文描述")
    private final String callTypeLabel;

    @Schema(name = "actionOrganizationName", title = "发起点名的单位(派出所或者单位)")
    private final String actionOrganizationName;

    @Schema(name = "securityStationId", title = "所在驻勤点Id")
    private final String securityStationId;

    @Schema(name = "securityStationName", title = "所在驻勤点")
    private final String securityStationName;

    @Schema(name = "calledEmployeeId", title = "被点名的人员的职员Id")
    private final String calledEmployeeId;

    @Schema(name = "calledEmployeeName", title = "被点名的人员的姓名")
    private final String calledEmployeeName;

    @Schema(name = "calledTenantUserId", title = "被点名的人的Id")
    private final String calledTenantUserId;

    @Schema(name = "stationResponsible", title = "是否为驻勤点负责人")
    private final boolean stationResponsible;

    @Schema(name = "tencentUserId", title = "音视频的腾讯UserId")
    private final String calledTencentUserId;

    @Schema(name = "calledOrganizationId", title = "被点名的人所在的企业Id")
    private final String calledOrganizationId;

    @Schema(name = "calledOrganizationName", title = "被点名的人所在的企业名称")
    private final String calledOrganizationName;

    @Schema(name = "createdTime", title = "点名时间")
    private final String createdTime;

    @Schema(name = "createdDate", title = "点名日期")
    private final String createdDate;

    @Schema(name = "superviseDepartId", title = "辖区Id")
    private final String superviseDepartId;

    public RollCallEmployeeSearchResponse(Long rollCallId,
                                          Timestamp createdTime,
                                          int callType, int callStatus,
                                          String actionOrganizationName, String securityStationId,
                                          String securityStationName,
                                          String superviseDepartId,
                                          String calledEmployeeId,
                                          String calledEmployeeName,
                                          String calledTenantUserId,
                                          String calledTencentUserId,
                                          String calledOrganizationId,
                                          String calledOrganizationName,
                                          boolean stationResponsible) {
        this.rollCallId = String.valueOf(rollCallId);
        Collection<RollCallStatus> selectedRollCallStatuses = RollCallStatus.getSelectedRollCallStatuses(callStatus);
        String statusLabel = "点名中";
        Collection<RollCallType> callTypes = RollCallType.getSelectedRollCallTypes(callType);
        if(callTypes.contains(RollCallType.Dispatch))
        {
            this.callTypeLabel="督导点名";
        }else {
            this.callTypeLabel="点名轮询";
        }

        if (selectedRollCallStatuses.contains(RollCallStatus.DispatchInit)) {
            statusLabel = ("督导点名中");
        }

        if (selectedRollCallStatuses.contains(RollCallStatus.RollCallSuccess)) {
            statusLabel = ("点名成功");
        }
        if (selectedRollCallStatuses.contains(RollCallStatus.RollCallFailed)) {
            statusLabel = ("点名失败");
        }
        if (selectedRollCallStatuses.contains(RollCallStatus.DispatchSuccess)) {
            statusLabel = ("督导点名成功");
        }

        if (selectedRollCallStatuses.contains(RollCallStatus.DispatchFailed)) {
            statusLabel = ("督导点名失败");
        }

        this.callStatusLabel = statusLabel.toString();
        this.actionOrganizationName = actionOrganizationName;
        this.securityStationId = securityStationId;
        this.securityStationName = securityStationName;
        this.createdTime = (new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(createdTime));
        this.createdDate = (new SimpleDateFormat("yyyy-MM-dd").format(createdTime));
        this.superviseDepartId = superviseDepartId;
        this.calledEmployeeId = calledEmployeeId;
        this.calledEmployeeName = calledEmployeeName;
        this.calledTenantUserId = calledTenantUserId;
        this.calledTencentUserId = calledTencentUserId;
        this.calledOrganizationId = calledOrganizationId;
        this.calledOrganizationName = calledOrganizationName;
        this.stationResponsible = stationResponsible;
    }

    public static RollCallEmployeeSearchResponse create(Long rollCallId,
                                                        Timestamp createdTime,
                                                        int callType, int callStatus,
                                                        String actionOrganizationName, String securityStationId,
                                                        String securityStationName,
                                                        String superviseDepartId,
                                                        String calledEmployeeId,
                                                        String calledEmployeeName,
                                                        String calledTenantUserId,
                                                        String calledTencentUserId,
                                                        String calledOrganizationId,
                                                        String calledOrganizationName,
                                                        boolean stationResponsible) {
        return new RollCallEmployeeSearchResponse(rollCallId, createdTime, callType, callStatus, actionOrganizationName, securityStationId,
                securityStationName, superviseDepartId, calledEmployeeId, calledEmployeeName, calledTenantUserId, calledTencentUserId,
                calledOrganizationId, calledOrganizationName,
                stationResponsible);
    }
}
