package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RollCallStatus;
import lombok.Getter;
import org.apache.commons.collections4.CollectionUtils;

import java.util.Collection;
import java.util.stream.Collectors;

@Getter
public class RollCallAutoCancelEmployeeResponse extends ResponseAbstract {



    private final Collection<RollCallAutoCancelEmployeeResponseItem> items;

    public int getAffectedCount() {
        if (CollectionUtils.isEmpty(this.getItems())) {
            return 0;
        }

        return this.getItems().size();
    }

    public RollCallAutoCancelEmployeeResponse(Collection<RollCallAutoCancelEmployeeResponseItem> items) {
        this.items = items;
    }

    public static RollCallAutoCancelEmployeeResponse create(Collection<RollCallAutoCancelEmployeeResponseItem> items) {
        return new RollCallAutoCancelEmployeeResponse(items);
    }

    @Getter
    public static class RollCallAutoCancelEmployeeResponseItem extends ResponseAbstract
    {
        private final String rollCallEmployeeId;
        private final String rollCallStatusLabel;

        public RollCallAutoCancelEmployeeResponseItem(String rollCallEmployeeId, int rollCallStatuses) {
            this.rollCallEmployeeId = rollCallEmployeeId;
            Collection<RollCallStatus> callStatuses = RollCallStatus.getSelectedRollCallStatuses(rollCallStatuses);
            if (CollectionUtils.isEmpty(callStatuses)) {
                this.rollCallStatusLabel = "无";
            } else {
                this.rollCallStatusLabel = callStatuses.stream().map(ii -> ii.getName()).collect(Collectors.joining(";"));
            }
        }

        public static RollCallAutoCancelEmployeeResponseItem create(String rollCallEmployeeId, int rollCallStatuses) {
            return new RollCallAutoCancelEmployeeResponseItem(rollCallEmployeeId, rollCallStatuses);
        }
    }
}
