package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RailRuleType;
import com.bcxin.tenant.open.infrastructures.enums.RailShapeType;
import com.bcxin.tenant.open.infrastructures.valueTypes.RdSecurityStationRailSnapshootValueType;
import com.bcxin.tenant.open.jdks.requests.RdSecurityStationRailSearchRequest;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.text.SimpleDateFormat;
import java.util.Date;

@Schema(name = "RdSecurityStationRailSearchResponse",title = "RdSecurityStationRailSearchResponse 电子围栏搜索结果")
@Getter
@JsonInclude(JsonInclude.Include.NON_NULL)
public class RdSecurityStationRailSearchResponse extends ResponseAbstract {
    @Schema(name = "id", title = "电子围栏id")
    private final String id;

    @Schema(name = "name", title = "名称")
    private final String name;

    @Schema(name = "shapeType", title = "形状: Circle=圆形; Crib=框形状; Polygon=多边形")
    private final RailShapeType shapeType;

    @Schema(name = "shapedLocation", title = "坐标及类型")
    private final RdSecurityStationRailSnapshootValueType.ShapedLocationValueType shapedLocation;

    @Schema(name = "stationId", title = "驻勤点id")
    private final String stationId;

    @Schema(name = "stationName", title = "驻勤点名称")
    private final String stationName;

    @Schema(name = "organizationId", title = "所属驻勤点的组织id")
    private final String organizationId;

    @Schema(name = "beginTime", title = "开始时间")
    private final String beginTime;

    @Schema(name = "endTime", title = "结束时间")
    private final String endTime;

    @Schema(name = "ruleType", title = "围栏类型")
    private final RailRuleType ruleType;

    @Schema(name = "note", title = "备注")
    private final String note;

    @Schema(name = "ruleTypeText", title = "围栏类型-文本")
    public String getRuleTypeText() {
        return ruleType == null ? "" : ruleType.getTypeName();
    }

    @Schema(name = "shapeTypeText", title = "形状-文本: Circle=圆形; Crib=框形状; Polygon=多边形")
    private final String shapeTypeText;

    public RdSecurityStationRailSearchResponse(
            RdSecurityStationRailSearchRequest.SearchModel model,
            long id, String name, RailShapeType shapeType,
            RdSecurityStationRailSnapshootValueType.ShapedLocationValueType shapedLocation,
            String stationId, String stationName, Date beginTime,
            Date endTime, RailRuleType ruleType, String note, String organizationId) {
        this.id = String.valueOf(id);
        this.shapeType = shapeType;
        this.shapedLocation = shapedLocation;
        this.organizationId = organizationId;

        if (model != RdSecurityStationRailSearchRequest.SearchModel.SecurityResource) {
            this.stationId = stationId;
            this.ruleType = ruleType;
            this.name = name;
            this.stationName = stationName;

            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            this.beginTime = dateFormat.format(beginTime);
            this.endTime = dateFormat.format(endTime);
            this.note = note;

            switch (this.getShapeType()) {
                case Crib -> {
                    this.shapeTypeText = "框形状";
                }
                case Polygon -> {
                    this.shapeTypeText = "多边形";
                }
                case Circle -> {
                    this.shapeTypeText = "圆形";
                }
                default -> {
                    this.shapeTypeText = "";
                }
            }
        } else {
            this.name = null;
            this.stationId = null;
            this.ruleType = null;
            this.stationName = null;
            this.beginTime = null;
            this.endTime = null;
            this.note = null;
            this.shapeTypeText = null;
        }
    }

    public static RdSecurityStationRailSearchResponse create(
            RdSecurityStationRailSearchRequest.SearchModel model,
            long id, String name, RailShapeType shapeType,
            RdSecurityStationRailSnapshootValueType.ShapedLocationValueType shapedLocation,
            String stationId, String stationName,
            Date beginTime, Date endTime, RailRuleType ruleType,
            String note, String organizationId) {
        return new RdSecurityStationRailSearchResponse(model, id, name, shapeType, shapedLocation, stationId, stationName, beginTime, endTime, ruleType, note, organizationId);
    }
}
