package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.Sex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

@Schema(name = "ProjectMemberResponse",title = "业务管理-项目成员")
@Getter
public class ProjectTeamMemberResponse extends ResponseAbstract {
    @Schema(name = "id", title = "项目Id")
    private final String id;
    @Schema(name = "name", title = "项目名称")
    private final String name;
    @Schema(name = "contact", title = "项目名称")
    private final String contact;
    @Schema(name = "personType", title = "人员类型")
    private final String personType;

    @Schema(name = "organizationId", title = "企业Id")
    private final String organizationId;
    @Schema(name = "companyName", title = "所属公司")
    private final String companyName;
    @Schema(name = "idCardNo", title = "证件号码")
    private final String idCardNo;
    @Schema(name = "sex", title = "姓名")
    private final String sex;


    public ProjectTeamMemberResponse(String id, String name,
                                     String contact, String personType,
                                     String organizationId,String companyName, String idCardNo, Sex sex) {
        this.id = id;
        this.name = name;
        this.contact = contact;
        this.personType = personType;
        this.organizationId = organizationId;
        this.companyName = companyName;
        this.idCardNo = idCardNo;
        this.sex = sex.getTypeName();
    }
}