package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;

@Schema(name = "ProjectOverviewResponse",title = "返回项目信息")
@Getter
public class ProjectOverviewResponse extends ResponseAbstract {
    @Schema(name = "id", title = "id")
    private final String id;
    @Schema(name = "name", title = "项目名称")
    private final String name;
    @Schema(name = "statusLabel", title = "状态")

    private final String statusLabel;

    @Setter
    private Set<String> scopePermissions;

    @Schema(name = "beginDate", title = "开始时间")
    private final String beginDate;

    @Schema(name = "endDate", title = "结束时间")
    private final String endDate;

    private final boolean valid;

    public ProjectOverviewResponse(String id, String name, String beginDateValue,String endDateValue) {
        this.id = id;
        this.name = name;

        Date now = new Date();
        DateFormat dateFormat = new SimpleDateFormat("M/d/yy, HH:mm");
        Date beginDt = null;
        if (beginDateValue != null) {
            try {
                beginDt = dateFormat.parse(beginDateValue);

                Calendar calendar = Calendar.getInstance();
                calendar.setTime(beginDt);
                calendar.set(Calendar.HOUR_OF_DAY, 0);
                calendar.set(Calendar.MINUTE, 0);
                calendar.set(Calendar.SECOND, 0);
                calendar.set(Calendar.MILLISECOND, 0);
                beginDt = calendar.getTime();
            } catch (Exception ex) {
            }
        }

        Date endDt = null;
        if (endDateValue != null) {
            try {
                endDt = dateFormat.parse(endDateValue);

                Calendar calendar = Calendar.getInstance();
                calendar.setTime(endDt);
                calendar.set(Calendar.HOUR_OF_DAY, 0);
                calendar.set(Calendar.MINUTE, 0);
                calendar.set(Calendar.SECOND, 0);
                calendar.set(Calendar.MILLISECOND, 0);

                // 加 1 天，得到明天的 0 点
                calendar.add(Calendar.DAY_OF_MONTH, 1);
                endDt = calendar.getTime();
            } catch (Exception ex) {
            }
        }

        if (beginDt != null && beginDt.after(now)) {
            this.statusLabel = "未开始";
            this.valid=true;
        } else if (endDt != null && endDt.before(now)) {
            this.statusLabel = "已结束";
            this.valid=false;
        } else {
            this.statusLabel = "进行中";
            this.valid = true;
        }

        this.beginDate = beginDateValue;
        this.endDate = endDateValue;
    }

    public static ProjectOverviewResponse create(String id, String name, String beginDate,String endDate) {
        return new ProjectOverviewResponse(id, name, beginDate, endDate);
    }
}
