package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

@Schema(name = "PoliceIncidentsLevelCountResponse",title = "PoliceIncidentsLevelCountResponse 警情上报事件等级统计")
@Getter
public class PoliceIncidentsLevelCountResponse extends ResponseAbstract {
    @Schema(name = "comonCount", title = "一般事件数")
    private final int comonCount;
    @Schema(name = "moreCount", title = "较大事件数")
    private final int moreCount;
    @Schema(name = "greatCount", title = "重大事件数")
    private final int greatCount;
    @Schema(name = "greatsCount", title = "特别重大事件数")
    private final int greatsCount;

    private final boolean fromRedis;

    public PoliceIncidentsLevelCountResponse(int comonCount, int moreCount,
                                             int greatCount, int greatsCount,
                                             boolean fromRedis) {
        this.comonCount = comonCount;
        this.moreCount = moreCount;
        this.greatCount = greatCount;
        this.greatsCount = greatsCount;
        this.fromRedis = fromRedis;
    }

    public static PoliceIncidentsLevelCountResponse create(int comonCount, int moreCount,
                                                           int greatCount, int greatsCount,
                                                           boolean fromRedis) {
        return new PoliceIncidentsLevelCountResponse(comonCount, moreCount, greatCount, greatsCount, fromRedis);
    }
}
