package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.util.Collection;

@Schema(name = "OrgPurseValidateResponse",title = "OrgPurseValidateResponse 调度前的联动值核对结果")
@Getter
public class OrgPurseValidateResponse extends ResponseAbstract {

    @Schema(name = "orgPurseItems",title = "各企业的调度前的联动值核对结果")
    private final Collection<OrgPurseItemResponse> orgPurseItems;

    public boolean IsDispatchable(String organizationId) {
        if (organizationId == null) {
            return false;
        }

        if (this.getOrgPurseItems() == null ||
                this.getOrgPurseItems().stream().allMatch(ii -> ii.getOrganizationId().equalsIgnoreCase(organizationId) && !ii.isDispatchable())) {
            return false;
        }

        return true;
    }

    public OrgPurseValidateResponse(Collection<OrgPurseItemResponse> orgPurseItems) {
        this.orgPurseItems = orgPurseItems;
    }


    public static OrgPurseValidateResponse create(Collection<OrgPurseItemResponse> orgPurseItems) {
        return new OrgPurseValidateResponse(orgPurseItems);
    }

    @Schema(name = "OrgPurseItemResponse",title = "企业的调度情况及联动值情况")
    @Getter
    public static class OrgPurseItemResponse extends ResponseAbstract {
        @Schema(name = "organizationId",title = "组织id")
        private final String organizationId;

        @Schema(name = "dispatchable",title = "该值为true的时候, 该企业的保安人员才可以被调度; 为false的时候, 该企业的保安人员不可被调度")
        private final boolean dispatchable;

        public OrgPurseItemResponse(String organizationId, boolean dispatchable) {
            this.organizationId = organizationId;
            this.dispatchable = dispatchable;
        }

        public static OrgPurseItemResponse create(String organizationId, boolean dispatchable) {

            return new OrgPurseItemResponse(organizationId, dispatchable);
        }
    }
}
