package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

@Schema(name = "ExamSiteResponse",title = "考试点信息")
@Getter
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ExamSiteResponse  extends ResponseAbstract {
    @Schema(name = "id", title = "考场Id")
    private final String id;
    @Schema(name = "name", title = "考场名称")
    private final String name;

    @Schema(name = "address", title = "详情地址")
    private final String address;

    @Schema(name = "companyName", title = "所在公司")
    private final String companyName;
    @Schema(name = "organizationId", title = "组织Id")
    private final String organizationId;

    /**
     * 考场数量
     */
    @Schema(name = "countOfRoom", title = "考场数量")
    private final int countOfRoom;

    /**
     * 容纳的人员数量
     */
    @Schema(name = "capacityOfPerson", title = "容纳的人员数量")
    private final int capacityOfPerson;

    @Schema(name = "region", title = "所在地区")
    private final String region;

    @Schema(name = "latitude", title = "考场所在y轴坐标")
    private final Double latitude;

    @Schema(name = "longitude", title = "考场所在x轴坐标")
    private final Double longitude;

    public ExamSiteResponse(String id, String name, String address, String organizationId, String companyName,
                            int countOfRoom, int capacityOfPerson, String region,
                            Double latitude,
                            Double longitude) {
        this.id = id;
        this.name = name;
        this.address = address;
        this.companyName = companyName;
        this.organizationId = organizationId;
        this.countOfRoom = countOfRoom;
        this.capacityOfPerson = capacityOfPerson;
        this.region = region;
        this.longitude = longitude;
        this.latitude = latitude;
    }

    public static ExamSiteResponse create(String id, String name, String address, String organizationId, String companyName,
                                          int countOfRoom, int capacityOfPerson, String region,
                            Double latitude,
                                          Double longitude) {
        return new ExamSiteResponse(id, name, address, organizationId, companyName, countOfRoom,
                capacityOfPerson, region,latitude,longitude);
    }
}
