package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.sql.Timestamp;

@Schema(name = "EmployeeTrackResponse",title = "EmployeeTrackResponse 人员轨迹信息")
@Getter
public class EmployeeTrackResponse extends ResponseAbstract {
    @Schema(name = "latitude", title = "纬度 y")
    private final double latitude;

    @Schema(name = "longitude", title = "经度 x")
    private final double longitude;

    private final Timestamp createdTime;

    public EmployeeTrackResponse(double latitude, double longitude,Timestamp createdTime) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.createdTime=createdTime;
    }

    public static EmployeeTrackResponse create(double latitude, double longitude,Timestamp createdTime) {
        return new EmployeeTrackResponse(latitude, longitude,createdTime);
    }
}
