package com.bcxin.tenant.open.jdks.responses;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RealNameAuthenticatedStatus;
import com.bcxin.tenant.open.infrastructures.enums.Sex;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

@Schema(name = "EmployeeAdvanceResponse",title = "EmployeeAdvanceResponse 业务管理的人员返回")
@Getter
@JsonInclude(JsonInclude.Include.NON_NULL)
public class EmployeeAdvanceResponse  extends ResponseAbstract {
    @ExcelIgnore
    @Schema(name = "id", title = "id")
    private final String id;
    @ExcelProperty("姓名")
    @Schema(name = "name", title = "姓名")
    private final String name;
    @ExcelProperty("性别")
    @Schema(name = "sexText", title = "性别")
    private final String sexText;
    @ExcelProperty("证件号")
    @Schema(name = "idCardNo", title = "保安员身份证")
    private final String idCardNo;
    @ExcelProperty("联系电话")
    @Schema(name = "contact", title = "保安员联系方式")
    private final String contact;
    @ExcelIgnore
    @Schema(name = "companyId", title = "公司Id")
    private final String companyId;
    @ExcelProperty("公司名称")
    @Schema(name = "companyName", title = "所在公司")
    private final String companyName;
    @ExcelIgnore
    @Schema(name = "superviseDepartId", title = "所在监管机构Id")
    private final String superviseDepartId;
    @ExcelProperty("所属监管机构")
    @Schema(name = "superviseDepartName", title = "所在监管机构")
    private final String superviseDepartName;
    @ExcelProperty("实名认证")
    @Schema(name = "authenticatedStatusText", title = "实名认证")
    private final String authenticatedStatusText;
    @ExcelProperty("持证情况")
    @Schema(name = "hasSecurityCertificateNo", title = "是否持证")
    private final boolean hasSecurityCertificateNo;
    @ExcelIgnore
    @Schema(name = "securityStationId", title = "所在驻勤点Id")
    private final String securityStationId;
    @ExcelProperty("所属驻勤点")
    @Schema(name = "securityStationName", title = "所在驻勤点")
    private final String securityStationName;

    public EmployeeAdvanceResponse(String id, String name, String sexText,
                                   String idCardNo, String contact,
                                   String companyId,
                                   String companyName,
                                   String superviseDepartId,
                                   String superviseDepartName, String authenticatedStatusText,
                                   boolean hasSecurityCertificateNo, String securityStationId,
                                   String securityStationName) {
        this.id = id;
        this.name = name;
        this.sexText = sexText;
        this.idCardNo = idCardNo;
        this.contact = contact;
        this.companyId = companyId;
        this.companyName = companyName;
        this.superviseDepartId = superviseDepartId;
        this.superviseDepartName = superviseDepartName;
        this.authenticatedStatusText = authenticatedStatusText;
        this.hasSecurityCertificateNo = hasSecurityCertificateNo;
        this.securityStationId = securityStationId;
        this.securityStationName = securityStationName;
    }

    public static EmployeeAdvanceResponse create(String id, String name, Sex sex,
                                                 String idCardNo, String contact,
                                                 String companyId,
                                                 String companyName,
                                                 String superviseDepartId,
                                                 String superviseDepartName,
                                                 RealNameAuthenticatedStatus authenticatedStatus,
                                                 boolean hasSecurityCertificateNo, String securityStationId,
                                                 String securityStationName) {
        return new EmployeeAdvanceResponse(id, name, sex.getTypeName(),
                idCardNo, contact, companyId, companyName, superviseDepartId,superviseDepartName, authenticatedStatus.getTypeName(),
                hasSecurityCertificateNo, securityStationId, securityStationName);
    }
}
