package com.bcxin.tenant.open.jdks.responses;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.CommunicatedType;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;

@Schema(name = "DispatchLogSearchResponse",title = "DispatchLogSearchResponse 调度日志信息搜索")
@Getter
@ColumnWidth(20)
public class DispatchLogSearchResponse extends ResponseAbstract {
    @ExcelProperty("调度编号")
    @Schema(name = "pkId", title = "调度编号")
    private final String pkId;

    @ExcelIgnore
    @Schema(name = "id", title = "主键")
    private final String id;

    @ExcelProperty("调度开始时间")
    @Schema(name = "BeginTime", title = "调度开始时间")
    private String beginTime;
    @ExcelProperty("调度结束时间")
    @Schema(name = "endTime", title = "调度结束时间")
    private final String endTime;

    @ExcelProperty("调度方式")
    @Schema(name = "communicatedType", title = "调度方式")
    private final String communicatedType;

    @ColumnWidth(50)
    @ExcelProperty("调度方")
    @Schema(name = "callerCompanyName", title = "调度方")
    private final String callerCompanyName;

    @ExcelProperty("调度账号编号")
    @Schema(name = "callerTencentUserId", title = "调度账号编号")
    private final String callerTencentUserId;

    @ColumnWidth(50)
    @ExcelProperty("被调度方")
    @Schema(name = "calledCompanyName", title = "被调度方企业名称")
    private final String calledCompanyName;
    @ExcelProperty("调度时长(分钟)")
    @Schema(name = "communicatedInMinutes", title = "调度时长(分钟)")
    private final int communicatedInMinutes;
    @ExcelProperty("消耗联动值")
    @Schema(name = "points", title = "消耗联动值")
    private final int points;

    @ExcelIgnore
    @Schema(name = "callerOrganizationId", title = "调度方企业Id")
    private final String callerOrganizationId;

    @ExcelIgnore
    @Schema(name = "calledOrganizationId", title = "被调度方企业Id")
    private final String calledOrganizationId;

    @ExcelIgnore
    @Schema(name = "createdTime", title = "调度结束时间")
    private final String createdTime;

    @ExcelIgnore
    @Schema(name = "paidByCaller", title = "是否调度方付款")
    private final boolean paidByCaller;

    @ExcelIgnore
    @Schema(name = "projectId", title = "-")
    private final String projectId;

    @Schema(name = "projectName", title = "项目名称")
    private final String projectName;

    public DispatchLogSearchResponse(
            Long pkId,
            String id, String callerTencentUserId, String callerCompanyName,
            String callerOrganizationId, Timestamp beginTime, Timestamp endTime,
            CommunicatedType communicatedType,
            String calledOrganizationId,
            String calledCompanyName,
            Timestamp createdTime,
            int communicatedInMinutes,
            int points,
            boolean paidByCaller,
            String projectId,
            String projectName) {
        this.id = id;
        this.callerTencentUserId = callerTencentUserId;
        this.callerCompanyName = callerCompanyName;
        this.callerOrganizationId = callerOrganizationId;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (beginTime != null) {
            this.beginTime = dateFormat.format(beginTime);
        }

        if (endTime != null) {
            this.endTime = dateFormat.format(endTime);
        } else {
            this.beginTime = "未接听";
            this.endTime = "未接听";
        }

        this.createdTime = dateFormat.format(createdTime);
        this.communicatedType = communicatedType == CommunicatedType.Video ? "视频" : (communicatedType == CommunicatedType.Audio ? "音频" : "其他");
        this.calledOrganizationId = calledOrganizationId;
        this.calledCompanyName = calledCompanyName;
        this.communicatedInMinutes = communicatedInMinutes;
        this.points = points;
        this.pkId = String.valueOf(pkId);
        this.paidByCaller = paidByCaller;
        this.projectId = projectId;
        this.projectName = projectName;
    }

    public static DispatchLogSearchResponse create(
            Long pkId,
            String id, String callerTencentUserId, String callerCompanyName,
            String callerOrganizationId,
            Timestamp beginTime, Timestamp endTime, CommunicatedType communicatedType,
            String calledOrganizationId,
            String calledCompanyName,
            Timestamp createdTime, int communicatedInMinutes, int points,
            boolean paidByCaller,
            String projectId,
            String projectName) {
        return new DispatchLogSearchResponse(
                pkId,
                id, callerTencentUserId, callerCompanyName,
                callerOrganizationId, beginTime, endTime, communicatedType, calledOrganizationId, calledCompanyName,
                createdTime,
                communicatedInMinutes, points, paidByCaller,projectId,projectName);
    }
}
