package com.bcxin.tenant.open.jdks.responses;

import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import org.apache.commons.collections4.CollectionUtils;

import java.util.Collection;
import java.util.stream.Collectors;

@Schema(name = "AttendanceValidationResponse",title = "返回验证结果")
@Getter
public class AttendanceValidationResponse extends ResponseAbstract {

    @Schema(name = "id", title = "驻勤点Id")
    private final String id;

    @Schema(name = "name", title = "驻勤点名称")
    private final String name;

    @Schema(name = "address", title = "驻勤点地址")
    private final String address;

    @Schema(name = "latitude", title = "驻勤点所在y轴坐标")
    private final Double latitude;

    @Schema(name = "longitude", title = "驻勤点所在x轴坐标")
    private final Double longitude;

    @Schema(name = "performRange", title = "驻勤点的执行范围（单位为米）")
    private final Double performRange;

    @Schema(name = "enableFaceValidation", title = "是否启用人脸验证; false为禁用人脸识别,其他则启用")
    private final boolean enableFaceValidation;

    @Schema(name = "ignoredPerformRangeLimited", title = "是否忽略执行范围的签到限制")
    private final boolean ignoredPerformRangeLimited;

    @Schema(name = "actionCode", title = "用于下一步的提交签到/签退的动作依据")
    private String actionCode;

    @Schema(name = "workstations", title = "其他工作点(驻勤点/岗点/点位信息);当此集合为非空的时候; 签到的时候展示该列表，让用户进行弹框选择要签的点位信息")
    private Collection<WorkstationValidationResponse> workstations;

    public AttendanceValidationResponse(String id, String name, String address, Double latitude, Double longitude, Double performRange,
                                        boolean enableFaceValidation, boolean ignoredPerformRangeLimited) {
        this.id = id;
        this.name = name;
        this.address = address;
        this.latitude = latitude;
        this.longitude = longitude;
        this.performRange = performRange;
        this.enableFaceValidation = enableFaceValidation;
        this.ignoredPerformRangeLimited = ignoredPerformRangeLimited;
    }

    public static AttendanceValidationResponse create(String id, String name, String address, Double latitude, Double longitude, Double performRange,
                                                      boolean enableFaceValidation, boolean ignoredPerformRangeLimited) {
        return new AttendanceValidationResponse(id, name, address, latitude, longitude, performRange, enableFaceValidation,
                ignoredPerformRangeLimited);
    }

    public void generateActionCode(String employeeId, String stationId) {
        this.actionCode = String.format("%s#%s", employeeId, stationId);
    }

    /**
     * 设置工作站信息
     * @param workstations
     */
    public void assignWorkstations(
            Collection<WorkstationValidationResponse> workstations) {
        String currentStationId = this.getId();

        Collection<WorkstationValidationResponse> matchedWorkStations = workstations;
        /**
         * 针对只有一个点位的情况, 如果是其本身，那么不返回
         */
        if (!CollectionUtils.isEmpty(workstations) && workstations.size()==1) {
            matchedWorkStations =
                    workstations.stream()
                            .filter(ii -> !ii.getId().equalsIgnoreCase(currentStationId))
                            .collect(Collectors.toList());
        }

        this.workstations = matchedWorkStations;
    }

    @Getter
    public static class WorkstationValidationResponse extends WorkstationResponse {
        @Schema(name = "ignoredPerformRangeLimited", title = "是否忽略执行范围的签到限制")
        private final boolean ignoredPerformRangeLimited;

        @Schema(name = "actionCode", title = "用于下一步的提交签到/签退的动作依据")
        private String actionCode;

        public WorkstationValidationResponse(WorkstationResponse response,
                                             boolean ignoredPerformRangeLimited) {
            super(response.getId(), response.getLatitude(), response.getLongitude(), response.getDisplayOrder(),
                    response.getName(), response.getAddress(), response.getPerformRange(),
                    response.getReferenceType(),
                    response.getReferenceLineId()
            );

            this.ignoredPerformRangeLimited = ignoredPerformRangeLimited;
        }

        public void generateActionCode(String employeeId) {
            this.actionCode = String.format("%s#%s", employeeId, this.getId());
        }

        public static WorkstationValidationResponse create(
                String employeeId,
                WorkstationResponse response,
                                                           boolean ignoredPerformRangeLimited) {
            WorkstationValidationResponse wvr = new WorkstationValidationResponse(response, ignoredPerformRangeLimited);
            wvr.generateActionCode(employeeId);

            return wvr;
        }
    }
}
