package com.bcxin.tenant.open.jdks.requests;


import com.bcxin.tenant.open.infrastructures.enums.ContentType;
import lombok.Data;

@Data
public class TenantWarnContentRequest extends RequestAbstract {
    private ContentType contentType;
    private String referenceNumber;
    private String content;

    public static TenantWarnContentRequest create(ContentType contentType,
                                                  String referenceNumber,
                                                  String content
                                                  ) {
        TenantWarnContentRequest request = new TenantWarnContentRequest();
        request.setContent(content);
        request.setContentType(contentType);
        request.setReferenceNumber(referenceNumber);

        return request;
    }
}
