package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.TRTCActionType;
import com.fasterxml.jackson.annotation.JsonSetter;
import lombok.Data;

import java.util.Arrays;
import java.util.Optional;

@Data
public class TRTCActionWriterRpcRequest extends RequestAbstract{
    private TRTCActionType action;
    private String[] tencentUserIds;

    @JsonSetter("action")
    public void setActionType(String action){
        Optional<TRTCActionType> actionOptional = Arrays.stream(TRTCActionType.values()).filter(ix->ix.getName().equalsIgnoreCase(action)).findFirst();
        if(actionOptional.isPresent()){
            this.action = actionOptional.get();
        }
    }
    public static TRTCActionWriterRpcRequest create(TRTCActionType action,String[] tencentUserIds){
        TRTCActionWriterRpcRequest request = new TRTCActionWriterRpcRequest();
        request.setAction(action);
        request.setTencentUserIds(tencentUserIds);
        return request;
    }
}
