package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.valueTypes.LonLatValueType;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Schema(name = "SearchNearByCompanyRequest",title = "SearchNearByCompanyRequest 根据坐标搜索周边")
@Data
public class SearchNearByCompanyRequest extends SearchRequestAbstract {
    @Schema(name = "locations", title = "坐标集合")
    private Collection<LonLatValueType> locations;
    @Schema(name = "distance", title = "周边搜索的半径长度定义,单位为米")
    private double distance;

    @Schema(name = "institutional", title = "机构类型")
    private Collection<String> institutional;


    public static SearchNearByCompanyRequest createForSecurityDepart(Collection<LonLatValueType> locations) {
        SearchNearByCompanyRequest request = new SearchNearByCompanyRequest();
        /**
         * 5公里范围的监管归属
         */
        request.setDistance(5*1000);
        request.setLocations(locations);
        request.setInstitutional(Stream.of("0107", "0108", "0109").collect(Collectors.toUnmodifiableList()));

        return request;
    }
}