package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.RepetitiveRule;
import com.bcxin.tenant.open.infrastructures.exceptions.NoAllowedTenantException;
import lombok.Data;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

@Data
public class ScheduledRollCallPlanSearchRequest extends RequestAbstract {
    private Timestamp scheduledTime;
    private RepetitiveRule repetitiveRule;


    public static ScheduledRollCallPlanSearchRequest create(Timestamp scheduledTime) {
        ScheduledRollCallPlanSearchRequest req = new ScheduledRollCallPlanSearchRequest();
        req.setScheduledTime(scheduledTime);
        Calendar nowCalendar = Calendar.getInstance();
        nowCalendar.setTime(scheduledTime);
        int weekday = nowCalendar.get(Calendar.DAY_OF_WEEK);

        RepetitiveRule selectedRule = RepetitiveRule.Monday;
        switch (weekday) {
            case 2:
                selectedRule = RepetitiveRule.Monday;
                break;
            case 3:
                selectedRule = RepetitiveRule.Tuesday;
                break;
            case 4:
                selectedRule = RepetitiveRule.Wednesday;
                break;
            case 5:
                selectedRule = RepetitiveRule.Thursday;
                break;
            case 6:
                selectedRule = RepetitiveRule.Friday;
                break;
            case 7:
                selectedRule = RepetitiveRule.Saturday;
                break;
            case 1:
                selectedRule = RepetitiveRule.Sunday;
                break;
            default:
                throw new NoAllowedTenantException();
        }

        req.setRepetitiveRule(selectedRule);

        return req;
    }
}
