package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.UserPurseTransactionType;
import lombok.Getter;

@Getter
public class DonatePointRequest extends RequestAbstract {
    private final UserPurseTransactionType referenceType;
    private final String referenceNumber;
    private final int points;
    private final String tenantUserId;

    private final String note;


    public DonatePointRequest(UserPurseTransactionType referenceType, String referenceNumber, int points, String tenantUserId,String note) {
        this.referenceType = referenceType;
        this.referenceNumber = referenceNumber;
        this.points = points;
        this.tenantUserId = tenantUserId;
        this.note = note;
    }

    public static DonatePointRequest create(UserPurseTransactionType referenceType, String referenceNumber, int points, String tenantUserId,String note) {
        return new DonatePointRequest(referenceType, referenceNumber, points, tenantUserId,note);
    }
}
