package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.BillType;
import lombok.Data;

import java.util.Collection;
import java.util.Date;

@Data
public class DailyBillWriteRequest extends RequestAbstract {
    private Date date;
    private Collection<BillType> billTypes;

    private DailyBillWriteRequest(Date date, Collection<BillType> billTypes) {
        this.date = date;
        this.billTypes = billTypes;
    }

    public static DailyBillWriteRequest create(Date date, Collection<BillType> billTypes) {
        return new DailyBillWriteRequest(date, billTypes);
    }
}
