package com.bcxin.tenant.open.jdks.requests;

import com.bcxin.tenant.open.infrastructures.enums.PoliceEventCategory;
import com.bcxin.tenant.open.infrastructures.enums.PoliceEventLevel;
import lombok.Data;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;

@Data
public class BroadcastPoliceIndicentMessageContentItem extends MessageContentItem {
    private String id;
    private String employeeId;
    private String empName;
    private String address;
    private String superDepartId;
    private double latitude;
    private double longitude;
    private String stationName;
    private String stationId;
    private String tencentUserId;
    private Timestamp createdTime;
    private PoliceEventCategory category;


    public BroadcastPoliceIndicentMessageContentItem() {
    }

    public static BroadcastPoliceIndicentMessageContentItem create(
            String id,
            PoliceEventCategory category,
            String employeeId,
            String empName,
            String address,
            String superDepartId,
            Timestamp createdTime,
            double latitude,
            double longitude) {
        BroadcastPoliceIndicentMessageContentItem data = new BroadcastPoliceIndicentMessageContentItem();
        data.setCategory(category);
        data.setAddress(address);
        data.setId(id);
        data.setSuperDepartId(superDepartId);
        data.setLatitude(latitude);
        data.setLongitude(longitude);
        data.setEmployeeId(employeeId);
        data.setEmpName(empName);
        data.setCreatedTime(createdTime);

        return data;
    }

    public void assignTencentUserInfo(String tencentUserId, String stationId, String stationName) {
        this.setTencentUserId(tencentUserId);
        this.setStationName(stationName);
        this.setStationId(stationId);
    }
}
