package com.bcxin.tenant.open.jdks;

import com.bcxin.tenant.open.infrastructures.EntityCollection;
import com.bcxin.tenant.open.jdks.requests.RollCallPlanRequest;
import com.bcxin.tenant.open.jdks.requests.RollCallPlanSearchRequest;
import com.bcxin.tenant.open.jdks.requests.ScheduledRollCallPlanSearchRequest;
import com.bcxin.tenant.open.jdks.responses.RollCallPlanDetailResponse;
import com.bcxin.tenant.open.jdks.responses.RollCallPlanResponse;
import com.bcxin.tenant.open.jdks.responses.RollCallPlanScheduledResponse;

import java.util.Collection;

public interface RollCallPlanRpcProvider {
    void create(RollCallPlanRequest request);

    void update(long id, RollCallPlanRequest request);

    void delete(long id);

    EntityCollection<RollCallPlanResponse> search(RollCallPlanSearchRequest request);

    RollCallPlanDetailResponse get(Long id);

    Collection<RollCallPlanScheduledResponse> getScheduledRollCallPlans(ScheduledRollCallPlanSearchRequest request);
}
