/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.jdks.responses;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.bcxin.tenant.open.infrastructures.ResponseAbstract;
import com.bcxin.tenant.open.infrastructures.enums.RailRuleType;
import com.bcxin.tenant.open.infrastructures.exceptions.BadTenantException;
import io.swagger.v3.oas.annotations.media.Schema;
import java.text.SimpleDateFormat;
import java.util.Date;

@Schema(name="SecurityStationRailMessageOverviewResponse", title="SecurityStationRailMessageOverviewResponse \u7535\u5b50\u56f4\u680f\u544a\u8b66\u4fe1\u606f")
@ColumnWidth(value=20)
public class SecurityStationRailMessageOverviewResponse
extends ResponseAbstract {
    @ExcelIgnore
    @Schema(name="id", title="id")
    private String id;
    @ExcelProperty(value={"\u544a\u8b66\u65f6\u95f4"})
    @Schema(name="eventDate", title="\u544a\u8b66\u65f6\u95f4")
    private final String eventDate;
    @ExcelProperty(value={"\u544a\u8b66\u7c7b\u578b"})
    @Schema(name="railRuleType", title="\u544a\u8b66\u7c7b\u578b")
    private final String railRuleTypeText;
    @ExcelProperty(value={"\u56f4\u680f\u540d\u79f0"})
    @Schema(name="stationRailName", title="\u56f4\u680f\u540d\u79f0")
    private final String stationRailName;
    @ExcelProperty(value={"\u59d3\u540d"})
    @Schema(name="employeeName", title="\u59d3\u540d")
    private final String employeeName;
    @ExcelProperty(value={"\u8eab\u4efd\u8bc1\u53f7"})
    @Schema(name="employeeIdCardNo", title="\u8eab\u4efd\u8bc1\u53f7")
    private final String employeeIdCardNo;
    @ColumnWidth(value=50)
    @ExcelProperty(value={"\u516c\u53f8\u540d\u79f0"})
    @Schema(name="companyName", title="\u516c\u53f8\u540d\u79f0")
    private final String companyName;
    @ColumnWidth(value=50)
    @ExcelProperty(value={"\u9a7b\u52e4\u70b9\u540d\u79f0"})
    @Schema(name="rail_reference_name", title="\u9a7b\u52e4\u70b9\u540d\u79f0")
    private final String rail_reference_name;
    @ColumnWidth(value=70)
    @ExcelProperty(value={"\u9a7b\u52e4\u70b9\u5730\u5740"})
    @Schema(name="rail_reference_address", title="\u9a7b\u52e4\u70b9\u5730\u5740")
    private final String rail_reference_address;
    @ColumnWidth(value=50)
    @ExcelProperty(value={"\u9a7b\u52e4\u70b9\u76d1\u7ba1\u673a\u6784"})
    @Schema(name="rail_reference_supervise_depart_name", title="\u9a7b\u52e4\u70b9\u76d1\u7ba1\u673a\u6784")
    private final String rail_reference_supervise_depart_name;
    @ExcelIgnore
    private final String projectId;
    @ExcelIgnore
    @Schema(name="projectName", title="\u9879\u76ee\u540d\u79f0")
    private final String projectName;

    public SecurityStationRailMessageOverviewResponse(Long pkId, Date eventDate, RailRuleType railRuleType, String stationRailName, String employeeName, String employeeIdCardNo, String companyName, String rail_reference_name, String rail_reference_address, String rail_reference_supervise_depart_name, String projectId, String projectName) {
        this.projectId = projectId;
        this.projectName = projectName;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.eventDate = dateFormat.format(eventDate);
        switch (railRuleType) {
            case Exit: {
                this.railRuleTypeText = "\u79bb\u5f00\u544a\u8b66";
                break;
            }
            case Enter: {
                this.railRuleTypeText = "\u8fdb\u5165\u544a\u8b66";
                break;
            }
            default: {
                throw new BadTenantException(String.format("\u975e\u9884\u671f\u544a\u8b66\u7c7b\u578b:%s", railRuleType));
            }
        }
        this.stationRailName = stationRailName;
        this.employeeName = employeeName;
        this.employeeIdCardNo = employeeIdCardNo;
        this.companyName = companyName;
        this.rail_reference_name = rail_reference_name;
        this.rail_reference_address = rail_reference_address;
        this.id = String.valueOf(pkId);
        this.rail_reference_supervise_depart_name = rail_reference_supervise_depart_name;
    }

    public static SecurityStationRailMessageOverviewResponse create(Long pkId, Date eventDate, RailRuleType railRuleType, String stationRailName, String employeeName, String employeeIdCardNo, String companyName, String rail_reference_name, String rail_reference_address, String rail_reference_supervise_depart_name, String projectId, String projectName) {
        return new SecurityStationRailMessageOverviewResponse(pkId, eventDate, railRuleType, stationRailName, employeeName, employeeIdCardNo, companyName, rail_reference_name, rail_reference_address, rail_reference_supervise_depart_name, projectId, projectName);
    }

    public String getId() {
        return this.id;
    }

    public String getEventDate() {
        return this.eventDate;
    }

    public String getRailRuleTypeText() {
        return this.railRuleTypeText;
    }

    public String getStationRailName() {
        return this.stationRailName;
    }

    public String getEmployeeName() {
        return this.employeeName;
    }

    public String getEmployeeIdCardNo() {
        return this.employeeIdCardNo;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public String getRail_reference_name() {
        return this.rail_reference_name;
    }

    public String getRail_reference_address() {
        return this.rail_reference_address;
    }

    public String getRail_reference_supervise_depart_name() {
        return this.rail_reference_supervise_depart_name;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getProjectName() {
        return this.projectName;
    }
}

