/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.tenant.open.document.domains.documents;

import com.bcxin.tenant.open.infrastructures.entities.EntityAbstract;
import com.bcxin.tenant.open.infrastructures.enums.InstantDataType;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.repository.query.SearchLanguage;
import org.springframework.data.annotation.Id;

@Document(language=SearchLanguage.CHINESE, timeToLive=300L)
public class InstantActivityDataDocument
extends EntityAbstract {
    @Indexed
    @Id
    public String id;
    private InstantDataType dataType;
    private String businessValue;
    private String referenceNumber;

    public static InstantActivityDataDocument create(InstantDataType dataType, String referenceNumber, String employeeId, String businessValue) {
        InstantActivityDataDocument document = new InstantActivityDataDocument();
        document.setId(InstantActivityDataDocument.generateId(referenceNumber, employeeId));
        document.setDataType(dataType);
        document.setBusinessValue(businessValue);
        document.setReferenceNumber(referenceNumber);
        return document;
    }

    public static String generateId(String referenceNumber, String employeeId) {
        return String.format("%s_%s", referenceNumber, employeeId);
    }

    public String getId() {
        return this.id;
    }

    public InstantDataType getDataType() {
        return this.dataType;
    }

    public String getBusinessValue() {
        return this.businessValue;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDataType(InstantDataType dataType) {
        this.dataType = dataType;
    }

    public void setBusinessValue(String businessValue) {
        this.businessValue = businessValue;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InstantActivityDataDocument)) {
            return false;
        }
        InstantActivityDataDocument other = (InstantActivityDataDocument)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        InstantDataType this$dataType = this.getDataType();
        InstantDataType other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        String this$businessValue = this.getBusinessValue();
        String other$businessValue = other.getBusinessValue();
        if (this$businessValue == null ? other$businessValue != null : !this$businessValue.equals(other$businessValue)) {
            return false;
        }
        String this$referenceNumber = this.getReferenceNumber();
        String other$referenceNumber = other.getReferenceNumber();
        return !(this$referenceNumber == null ? other$referenceNumber != null : !this$referenceNumber.equals(other$referenceNumber));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InstantActivityDataDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        InstantDataType $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        String $businessValue = this.getBusinessValue();
        result = result * 59 + ($businessValue == null ? 43 : $businessValue.hashCode());
        String $referenceNumber = this.getReferenceNumber();
        result = result * 59 + ($referenceNumber == null ? 43 : $referenceNumber.hashCode());
        return result;
    }

    public String toString() {
        return "InstantActivityDataDocument(id=" + this.getId() + ", dataType=" + this.getDataType() + ", businessValue=" + this.getBusinessValue() + ", referenceNumber=" + this.getReferenceNumber() + ")";
    }
}

