package com.bcxin.backend.domain.models;

import lombok.Data;
import org.springframework.util.StringUtils;

@Data
public class SuperviseDTO {
    protected String regionId;
    /**
     * 用户Id
     */
    protected String systemAdmin;
    protected String srcApp;
    protected String targetApp;
    protected String callbackUrl;
    protected String targetServiceUrl;

    public SuperviseDTO clone() {
        SuperviseDTO superviseDTO = new SuperviseDTO();
        superviseDTO.setTargetServiceUrl(targetServiceUrl);
        superviseDTO.setCallbackUrl(callbackUrl);
        superviseDTO.setSrcApp(srcApp);
        superviseDTO.setSystemAdmin(systemAdmin);
        superviseDTO.setTargetApp(targetApp);
        superviseDTO.setTargetServiceUrl(targetServiceUrl);
        superviseDTO.setRegionId(regionId);

        return superviseDTO;
    }

    public boolean isValid() {
        return StringUtils.hasLength(targetApp);
    }
}
