package com.bcxin.backend.domain;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

@Component
public class SimpleLocalLockComponent {
    private final static Logger logger = LoggerFactory.getLogger(SimpleLocalLockComponent.class);

    private static Set<String> lockSetContainer = new HashSet<>();

    public boolean enter(Class tClass) {
        return lockSetContainer.add(tClass.getName());
    }

    public void exit(Class tClass) {
        lockSetContainer.remove(tClass.getName());
    }

    public boolean enter(String key) {
        if (lockSetContainer.add(key)) {
            if (lockSetContainer.size() > 200) {
                logger.warn("总共{}任务在执行..，已经达到最大10个限额", lockSetContainer.stream().collect(Collectors.joining(";")));
                return false;
            }
        }

        return true;
    }

    public void exit(String key) {
        lockSetContainer.remove(key);
    }
}
