/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.screening.service.impl;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.backend.domain.models.Result;
import com.bcxin.backend.domain.models.ScreeningDTO;
import com.bcxin.backend.domain.screening.service.BackgrounpScreeningProvider;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component(value="bsp_hunan")
public class BackgrounpScreeningProviderHunanImpl
implements BackgrounpScreeningProvider {
    private static final Logger log = LoggerFactory.getLogger(BackgrounpScreeningProviderHunanImpl.class);
    @Autowired
    @Qualifier(value="primaryJdbcTemplate")
    protected JdbcTemplate jdbcTemplate;
    @Value(value="${myapps.screeninng.api}")
    private String baseUrl;

    public JSONObject getScreenOfAuth(String idnum) {
        HttpResponse execute = HttpUtil.createGet((String)(this.baseUrl + idnum)).execute();
        if (execute.isOk()) {
            JSONObject screenValue = JSON.parseObject((String)execute.body());
            return screenValue;
        }
        return null;
    }

    public ScreeningDTO getScreen(String idnum, List<String> logList) {
        JSONObject screenValue = this.getScreenOfAuth(idnum);
        if (!ObjectUtils.isEmpty((Object)screenValue)) {
            if (ObjectUtils.isEmpty((Object)screenValue.get((Object)"data"))) {
                String replaceScreenValue = JSON.toJSONString((Object)screenValue).replace("\"", "\\\"");
                this.setLogList(logList, "2", idnum, null, replaceScreenValue);
                return new ScreeningDTO(idnum, "0", "");
            }
            JSONObject dataJson = (JSONObject)screenValue.get((Object)"data");
            String hnProblemData = "\u516c\u5b89\u90e8\u5728\u9003\u4eba\u5458";
            String hnProblemWffzry = "\u516c\u5b89\u90e8\u8fdd\u6cd5\u72af\u7f6a\u4eba\u5458";
            ArrayList<String> questiontypeList = new ArrayList<String>();
            if (!ObjectUtils.isEmpty((Object)dataJson.get((Object)"censorResult"))) {
                String censorResultArry = dataJson.get((Object)"censorResult").toString();
                JSONArray jsonArray = JSONArray.parseArray((String)censorResultArry);
                for (int i = 0; i < jsonArray.size(); ++i) {
                    String wffzry;
                    String detail;
                    JSONObject dJson;
                    String data;
                    JSONObject object = jsonArray.getJSONObject(i);
                    if (object.containsKey((Object)"data") && !ObjectUtils.isEmpty((Object)(data = object.get((Object)"data").toString())) && !data.equals("null") && (dJson = (JSONObject)object.get((Object)"data")).containsKey((Object)"detail") && !ObjectUtils.isEmpty((Object)(detail = dJson.get((Object)"detail").toString())) && !detail.equals("null")) {
                        questiontypeList.add(detail);
                    }
                    if (object.containsKey((Object)"wffzry") && !ObjectUtils.isEmpty((Object)(wffzry = object.get((Object)"wffzry").toString())) && !wffzry.equals("null")) {
                        questiontypeList.add(hnProblemWffzry);
                    }
                    if (!object.containsKey((Object)"result") && !object.containsKey((Object)"cxxt")) continue;
                    String result = object.get((Object)"result").toString();
                    String cxxt = object.get((Object)"cxxt").toString();
                    if (ObjectUtils.isEmpty((Object)result) || result.equals("null") || result.equals("0") || ObjectUtils.isEmpty((Object)cxxt) || cxxt.equals("null")) continue;
                    questiontypeList.add(cxxt);
                }
            } else {
                String replaceScreenValue = JSON.toJSONString((Object)screenValue).replace("\"", "\\\"");
                this.setLogList(logList, "2", idnum, null, replaceScreenValue);
                return new ScreeningDTO(idnum, "0", "");
            }
            String replaceScreenValue = JSON.toJSONString((Object)screenValue).replace("\"", "\\\"");
            this.setLogList(logList, "2", idnum, ((Object)questiontypeList).toString().replace("[", "").replace("]", ""), replaceScreenValue);
            return new ScreeningDTO(idnum, "1", ((Object)questiontypeList).toString().replace("[", "").replace("]", ""));
        }
        return null;
    }

    @Override
    public Result<ScreeningDTO> screening(String idnum) {
        ArrayList<String> logList = new ArrayList<String>();
        ScreeningDTO screenOfAuth = this.getScreen(idnum, logList);
        this.saveLog(logList);
        return new Result<ScreeningDTO>().success("\u64cd\u4f5c\u6210\u529f\uff01", screenOfAuth);
    }

    @Override
    public Result<List<ScreeningDTO>> screenings(String[] idnums) {
        ArrayList list = Lists.newArrayList();
        ArrayList<String> logList = new ArrayList<String>();
        ScreeningDTO screeningDTO = null;
        for (String idnum : idnums) {
            screeningDTO = this.getScreen(idnum, logList);
            if (screeningDTO == null) continue;
            list.add(screeningDTO);
        }
        this.saveLog(logList);
        return new Result<ArrayList>().success("\u64cd\u4f5c\u6210\u529f\uff01", list);
    }

    private void setLogList(List<String> list, String type, String idnum, String short_result, String result) {
        list.add("( '" + type + "',NOW(),'" + idnum + "','" + short_result + "','" + result + "' )");
    }

    private void saveLog(List<String> list) {
        if (list.size() > 0) {
            String lStr = list.toString();
            StringBuilder sb = new StringBuilder();
            sb.append("INSERT INTO bg_screening_user_exec_logs (type,created_time,idnum,short_result,result) values" + lStr.substring(1, lStr.length() - 1));
            this.jdbcTemplate.update(sb.toString());
        }
    }
}

