package com.baichuanxin.openrestapi.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baichuanxin.openrestapi.common.OnlineTaskConstant;
import com.baichuanxin.openrestapi.common.utils.OnlineTaskUtil;
import com.baichuanxin.openrestapi.dao.mapper.NoticeMapper;
import com.baichuanxin.openrestapi.entity.ChangeLegalPerson;
import com.baichuanxin.openrestapi.entity.Notice;
import com.baichuanxin.openrestapi.entity.SecurityServicek;
import com.baichuanxin.openrestapi.service.NoticeService;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * description: 办件通知service
 *
 */
@Slf4j
@Service
public class NoticeServiceImpl extends ServiceImpl<NoticeMapper,Notice> implements NoticeService {
    @Autowired
    private NoticeMapper noticeMapper ;
    @Override
    public void getNotice(String noticeData) {
        Notice notice = JSON.parseObject(noticeData, Notice.class);
        Notice noticeById = noticeMapper.selectById(notice.getTaskId());
        if (noticeById == null){
            noticeMapper.insert(notice);
        }else {
            Map<String ,Object> confirmMap=new HashMap<>();
            confirmMap.put("confirmType", OnlineTaskConstant.CONFIRM_TYPE_0);
            //业务数据保存成功，告诉第三方已经接受数据
            OnlineTaskUtil.taskConfirm(notice.getTaskId(), confirmMap);
            log.info("========================当前taskID已存在{}",notice.getTaskId());
        }
    }

    /**
     *@Author duxiangyun
     *@Description 根据办件状态查询未取回数据的办件ID
     *@Date 2024/8/24
     */
    @Override
    public Notice getUnFinishTask() {
        QueryWrapper<Notice> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("status",0).last("limit 1");
        return this.getOne(queryWrapper);
    }

    /***
     *@Author duxiangyun
     *@Description 根据任务Id来修改任务状态
     *@Date 2024/8/24
     */
    @Override
    public boolean updateNoticeStatus(String taskId,int status,int fileStatus) {
        UpdateWrapper<Notice> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("taskId",taskId);
        updateWrapper.set("status",status);
        updateWrapper.set("fileStatus",fileStatus);
//        updateWrapper.set() 更新时间
        return this.update(updateWrapper);
    }

    @Override
    public boolean updateNoticeSentFileStatus(String taskId, int fileStatus) {
        return false;
    }

//    /***
//     *@Author duxiangyun
//     *@Description 根据任务Id来修改文件下发任务状态
//     *@Date 2024/8/24
//     */
//    @Override
//    public boolean updateNoticeSentFileStatus(String taskId,int fileStatus) {
//        UpdateWrapper<Notice> updateWrapper = new UpdateWrapper<>();
//        updateWrapper.eq("taskId",taskId)
//                .set("fileStatus",fileStatus);
//        return this.update(updateWrapper);
//    }
    /***
     *@Author duxiangyun
     *@Description  更新通知表数据，获取办件信息时使用
     *@Date 2024/8/26
     */
    @Override
    public int updateNoticeOneByTaskId(Notice notice) {
        int i = noticeMapper.updateById(notice);
        log.info("==============Notice办件数据已经获取,taskId:{}=============",notice.getTaskId());
        return i;
    }
    /***
     *@Author duxiangyun
     *@Description 取回为完成返回结果的数据
     *@Date 2024/8/26
     */
    @Override
    public List<Notice> getUnReturnList(int status, int fileStatus,String matId) {
        QueryWrapper<Notice> queryWrapper =new QueryWrapper<>();
        queryWrapper.eq("status",status);
        queryWrapper.eq("fileStatus",fileStatus);
        queryWrapper.eq("matId",matId);
//        queryWrapper.orderByAsc("");   //审核通过时间
        return this.list(queryWrapper);
    }

    /**
     * 查询备案事项未返回审核数据的taskID
     * @param status
     * @param matIdList
     * @return
     */
    @Override
    public List<Notice> getUnReturnListBymatIdList(int status, List<String> matIdList) {
        QueryWrapper<Notice>  queryWrapper =new QueryWrapper<>();
        queryWrapper.in("matId",matIdList);
        queryWrapper.eq("status",status).last("limit 10");
        return this.list(queryWrapper);
    }

    @Override
    public List<Notice> getUnSentResultFile(String matId) {
        QueryWrapper<Notice>  queryWrapper =new QueryWrapper<>();
        queryWrapper.eq("matId",matId);
        queryWrapper.eq("fileStatus",1);  //还没进行发送办件结果物的数据。
        return this.list(queryWrapper);
    }
    @Override
    public List<Notice> getCheckTaskFile() {
        QueryWrapper<Notice> queryWrapper =new QueryWrapper<>();
        queryWrapper.eq("status","1");
        queryWrapper.eq("fileStatus", "0");
        queryWrapper.in("matId",OnlineTaskConstant.MAT_ID_0,OnlineTaskConstant.MAT_ID_1);
        queryWrapper.orderByAsc("createTime");
        return  this.list(queryWrapper);

    }




}
