package com.baichuanxin.openrestapi.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;


/***
 *@Author duxiangyun
 *@Description  保安员资格证
 *@Date 2024/8/27
 */
@Data
@TableName("kp_jgww.tlk_certificate_approval")
public class CertificateService {

    //表单相关数据
    @TableId("ID")
    private String  id;
    //表单需求数据
    //创建时间
    @TableField("CREATED")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date created;
    @TableField("LASTMODIFIED")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date lastmodified;
    @TableField("FORMNAME")
    private String formname;
    @TableField("FORMID")
    private String formid;
    @TableField("ISTMP")
    private boolean istmp;
    @TableField("APPLICATIONID")
    private String applicationid;
    @TableField("DOMAINID")
    private String domainid;
    @TableField("item_region")
    private String itemRegion;

    //办件相关数据
    @TableField("taskId")
    private String taskId;
    /**
     *@Author duxiangyun
     *@Description   用户提交数据
     *@Date 2024/8/28
     */
    //申请人姓名
    @TableField("item_name")
    private String itemName;
    //申请人身份号码
    @TableField("item_Document_Id")
    private String itemDocumentId;
    //联系电话
    @TableField("item_phone")
    private String itemPhone;
    //性别
    @TableField("item_sex")
    private String itemSex;
    //民族
    @TableField("item_nation")
    private String itemNation;
    //籍贯
    @TableField("item_native_place")
    private String itemNativePlace;
    //出生年月
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @TableField("item_birthday")
    private Date itemBirthday;
    //文化程度
    @TableField("item_education")
    private String  itemEducation;
    //户籍地址
    @TableField("item_residence_address")
    private String itemResidenceAddress;
    //政治面貌
    @TableField("item_political_outlook")
    private String itemPoliticalOutlook;
    //考试区域
    @TableField("item_exam_area")
    private String itemExamArea;
    @TableField(value = "item_officePoliceAddress")
    private String itemOfficePoliceAddress;
    @TableField("ITEM_OFFICEPOLICEADDRESSID")
    private String itemOfficePoliceAddressid;
    @TableField("ITEM_OFFICEPOLICEIDINDEX")
    private String itemOfficePoliceidindex;

    //工作单位或常住地址
    @TableField("item_work_address")
    private String itemWorkAddress;
    //报名时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @TableField("item_application_time")
    private String itemApplicationTime;
    //有效身份证原件正、反面
    @TableField("item_idcard_file")
    private String itemIdcardFile;
    //县级以上医疗机构出具的体检证明
    @TableField("item_physical_file")
    private String itemPhysicalFile;
    //初中以上学历证明
    @TableField("item_education_file")
    private String itemEducationFile;
    //彩色寸照
    @TableField("item_inch_file")
    private String itemInchFile;

    //承诺上述填报信息真实有效
    @TableField("item_permit")
    private String itemPermit;
    /***
     *@Author duxiangyun
     *@Description   审核状态数据
     *@Date 2024/8/28
     */
    //审核状态
    @TableField("item_approval_status")
    private String itemApprovalStatus;
    //审核时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    @TableField("item_approval_time")
    private Date itemApprovalTime;
    // 审核意见
    @TableField("item_approval_remark")
    private String itemApprovalRemark;

}
