package com.baichuanxin.openrestapi.dtos;

/**
 * 设立保安服务公司主要管理人员及技术人员信息
 */

import cn.hutool.core.util.StrUtil;
import com.baichuanxin.openrestapi.common.OnlineTaskConstant;
import com.baichuanxin.openrestapi.common.utils.OnlineTaskUtil;

import com.baichuanxin.openrestapi.entity.ManagerInfo;
import com.baichuanxin.openrestapi.entity.Notice;
import lombok.Data;

import java.util.Date;

@Data
public class ManagerInfoDto {

    //姓名
    private String item_name;
    //职务
    private String  zw_ga;
    //证件类型
    private String  item_documentType;
    //证件号码
    private String  item_documentID;
    //保安职业资格证书编号或其他相应专业资格证书编号
    private String bazyzgzsbh;

    public ManagerInfo convert(){
        ManagerInfo managerInfo  = new ManagerInfo();
        Date now = new Date();
        //表单需求数据
        managerInfo.setCreated(now);
        managerInfo.setLastmodified(now);
        managerInfo.setDomainid("__UDa4uPMdcOYgP7HETaf");
        managerInfo.setIstmp(true);
        managerInfo.setFormid(OnlineTaskConstant.MANAGER_INFO);
        managerInfo.setApplicationid("__JvOHkqjhV41mUo4ITRv");
        managerInfo.setItemRegion("湖南省");
        managerInfo.setItemName(this.getItem_name());
        managerInfo.setItemJobType(this.getZw_ga());
        managerInfo.setItemDocumentType(OnlineTaskUtil.idCardType2Convert(this.getItem_documentType()));
        managerInfo.setItemDocumentID(this.getItem_documentID());
        managerInfo.setItemQualificationId(this.getBazyzgzsbh());
        return managerInfo;
    }
}
