/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.signature.util.ftp;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FtpClientPool {
    private static final Logger logger = LoggerFactory.getLogger(FtpClientPool.class);
    private final BlockingQueue<FTPClient> pool = new LinkedBlockingQueue();
    private final String server;
    private final String user;
    private final String password;
    private final int port;

    public FtpClientPool(int size, String server, int port, String user, String password) {
        this.server = server;
        this.port = port;
        this.user = user;
        this.password = password;
        for (int i = 0; i < size; ++i) {
            try {
                FTPClient ftpClient = new FTPClient();
                FtpClientPool.initConnect((FTPClient)ftpClient, (String)this.server, (int)this.port, (String)this.user, (String)this.password);
                this.pool.add(ftpClient);
                continue;
            }
            catch (Exception ex) {
                System.err.println("Failed to initialze the ftp client");
            }
        }
    }

    public synchronized FTPClient borrowConnection() {
        FTPClient ftpClient = null;
        do {
            if (!(ftpClient = (FTPClient)this.pool.poll()).isConnected()) {
                try {
                    FtpClientPool.initConnect((FTPClient)ftpClient, (String)this.server, (int)this.port, (String)this.user, (String)this.password);
                }
                catch (Exception ex) {
                    logger.error("{} reconnect-Failed to initialze the ftp client", (Object)ftpClient.hashCode(), (Object)ex);
                }
            }
            if (ftpClient != null) break;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (ftpClient == null);
        return ftpClient;
    }

    public synchronized void returnConnection(FTPClient conn) {
        if (conn != null) {
            try {
                conn.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.pool.offer(conn);
        }
    }

    public void closeAll() throws IOException {
        for (FTPClient conn : this.pool) {
            conn.disconnect();
        }
    }

    private static void initConnect(FTPClient ftpClient, String host, int port, String user, String password) throws IOException {
        try {
            if (!ftpClient.isConnected()) {
                ftpClient.connect(host, port);
                ftpClient.setBufferSize(0x100000);
                ftpClient.setControlKeepAliveReplyTimeout(300000);
            }
        }
        catch (UnknownHostException ex) {
            throw new IOException("Can't find FTP server '" + host + "'");
        }
        ftpClient.enterLocalPassiveMode();
        int reply = ftpClient.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            FtpClientPool.disconnect();
            throw new IOException("Can't connect to server '" + host + "'");
        }
        if (!ftpClient.login(user, password)) {
            FtpClientPool.disconnect();
            throw new IOException("Can't login to server '" + host + "'");
        }
    }

    public static void disconnect() throws IOException {
    }

    public FTPClient newFTPClient() throws IOException {
        FTPClient ftpClient = new FTPClient();
        FtpClientPool.initConnect((FTPClient)ftpClient, (String)this.server, (int)this.port, (String)this.user, (String)this.password);
        return ftpClient;
    }
}

