package com.baichuanxin.openrestapi.dtos;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baichuanxin.openrestapi.common.OnlineTaskConstant;
import com.baichuanxin.openrestapi.common.utils.OnlineTaskUtil;
import com.baichuanxin.openrestapi.entity.Notice;
import com.baichuanxin.openrestapi.entity.RegistrationBranch;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 *@Author duxiangyun
 *@Description 注册分公司业务数据解析
 *@Date 2024/8/30
 */
@Data
public class RegisterBranchDto {


    //不详细字段 item_address
    /**
     * 1、选择办事区域
     */
    //所属监管机构 item_officePoliceAddress;
    private String  item_officePoliceAddress;
    /**
     * 2、填写总公司信息
     */
    //总公司名称
    private String item_companyName;
    //公司地址
    private String item_address;
    //统一社会信用代码
    private String item_creditCode;
    //保安服务许可证号
    private String item_licenceNum;
    //联系电话
    private String zgslxdh;
    //法人姓名
    private String item_legalName;
    //法人证证件类型
    private String item_legalType;
    //法人证件号码
    private String  item_legalCardnumber;
    //法人手机号码
    private  String item_legalPhone;

    /**
     * 3、拟设立分公司信息
     */
    //分公司名称
    private String nslfgsmc;
    //办公地址--------------------------------------
    private String nslgsdz;
    //统一社会信用代码
    private String nslgsshxydm;
    //联系电话
    private String nslgsdh;
    //经营范围
    private List<String > sqfwfw;
    /**
     * 4、填写分公司负责人信息   ++++ 单行数据设置成了多行
     */
//    List<BranchChargeDto> txfgsryxx;
    //姓名
    private String item_chargeName;
    //联系电话
    private String item_chargePhone;
    //职务
    private String item_chargePost;
    //居民身份证号
    private String item_chargeCardnumber;
    //性别
    private String item_charge_sex;
    //年龄
    private String item_charge_age;
    //籍贯
    private String item_charge_household;
    //民族
    private String item_charge_nation;
    //现住址
    private String item_charge_address;
    //中华人民共和国职业资格证书号
    private String item_charge_certificate;
    //工作简历
    private String item_job_resume;

    /**
     *   保安员信息
     */
    private List<SecurityManDto> bayxx;

    /**
     * 经办人信息
     */
    //姓名
    private String item_applicant_name;
    //联系电话
    private String item_applicant_phone;

    /**
     * item_permit
     */
    //承诺上述填报信息真实有效
    private String  item_permit;


    public RegistrationBranch convert(Notice notice){
        RegistrationBranch registrationBranch  = new RegistrationBranch();
        Date now  = new Date();
        //审核数据
        registrationBranch.setItemAuditStatus("3");
        //办件数据
        registrationBranch.setTaskId(notice.getTaskId());
        //表单需求数据
        registrationBranch.setId(StrUtil.join("--",notice.getTaskId(), OnlineTaskConstant.REGISTRATION_BRANCH));
        registrationBranch.setCreated(now);
        registrationBranch.setLastmodified(now);
        registrationBranch.setFormname("");
        registrationBranch.setFormid(OnlineTaskConstant.REGISTRATION_BRANCH);
        registrationBranch.setIstmp(true);
        registrationBranch.setApplicationid("__JvOHkqjhV41mUo4ITRv");
        registrationBranch.setDomainid("__UDa4uPMdcOYgP7HETaf");
        registrationBranch.setItemRegion("湖南省");
        registrationBranch.setIsdelivery("0");
        //选择办事区域
        registrationBranch.setItemOfficePoliceAddress(this.getItem_officePoliceAddress());
        //填写总公司信息
        registrationBranch.setItemCompanyName(this.getItem_companyName());
        //格式化公司地址
        AddressDto addressDto = JSON.parseObject(this.getItem_address(), AddressDto.class);
        registrationBranch.setItemAddress(addressDto.convert());
        registrationBranch.setItemCreditCode(this.getItem_creditCode());
        registrationBranch.setItemLicenceNum(this.getItem_licenceNum());
        registrationBranch.setItemPhone(this.getZgslxdh());
        registrationBranch.setItemLegalName(this.getItem_legalName());
        registrationBranch.setItemLegalType(OnlineTaskUtil.idCardTypeConvert(this.getItem_legalType()));
        registrationBranch.setItemLegalCardnumber(OnlineTaskUtil.decrypt(this.getItem_legalCardnumber()));
        registrationBranch.setItemLegalPhone(this.getItem_legalPhone());


        //拟设立分公司信息
        registrationBranch.setItemSonCompanyName(this.getNslfgsmc());
        registrationBranch.setItemSonAddress(this.getNslgsdz());
        registrationBranch.setItemSonCreditCode(this.getNslgsshxydm());
        registrationBranch.setItemSonPhone(this.getNslgsdh());
        registrationBranch.setItemSonBusinessScope(OnlineTaskUtil.scopConvert(this.getSqfwfw()));

        //分公司负责人信息
        registrationBranch.setItemChargeName(this.getItem_chargeName());
        registrationBranch.setItemChargePhone(this.getItem_chargePhone());
        registrationBranch.setItemChargePost(OnlineTaskUtil.jobConvert(this.getItem_chargePost()));
        registrationBranch.setItemChargeCardnumber(OnlineTaskUtil.decrypt(this.getItem_chargeCardnumber()));
        registrationBranch.setItemChargeSex(this.getItem_charge_sex());
        registrationBranch.setItemChargeAge(this.getItem_charge_age());
        registrationBranch.setItemChargeHousehold(this.getItem_charge_household());
        registrationBranch.setItemChargeNation(this.getItem_charge_nation());
        registrationBranch.setItemChargeAddress(this.getItem_charge_address());
        registrationBranch.setItemChargeCertificate(this.getItem_charge_certificate());
        registrationBranch.setItemJobResume(this.getItem_job_resume());
        //保安员信息
        if (this.getBayxx()!= null){
            if (this.getBayxx().size() > 0){
                registrationBranch.setItemPersonNum(this.getBayxx().get(0).getItem_person_num().toString());
            }
        }
        //经办人信息
        registrationBranch.setItemApplicantName(this.getItem_applicant_name());
        registrationBranch.setItemApplicantPhone(this.getItem_applicant_phone());

        //承诺填报信息真实有效
        registrationBranch.setItemPermit(this.getItem_permit());

        return registrationBranch;


    }



}
