/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.auth.service.impl;

import com.bcxin.backend.core.exceptions.SaasBadException;
import com.bcxin.backend.domain.auth.dtos.AuthLog;
import com.bcxin.backend.domain.auth.dtos.AuthRequestDto;
import com.bcxin.backend.domain.auth.factory.AuthFactory;
import com.bcxin.backend.domain.models.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public abstract class AuthenticationServiceAbstractImpl {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationServiceAbstractImpl.class);
    private static Logger logger = LoggerFactory.getLogger(AuthenticationServiceAbstractImpl.class);
    private final AuthFactory authFactory;
    @Autowired
    @Qualifier(value="primaryJdbcTemplate")
    protected JdbcTemplate jdbcTemplate;

    public AuthenticationServiceAbstractImpl(AuthFactory authFactory) {
        this.authFactory = authFactory;
    }

    public abstract String findUnAuthSql();

    public Boolean auth() {
        logger.info("-----------------------------------------------\u5b9e\u540d\u8ba4\u8bc1\u7a0b\u5e8f\u5f00\u59cb\u6267\u884c--------------------------------------------------------------");
        try {
            List<AuthRequestDto> authRequestDtos = this.getPendingBgScreenUsers();
            logger.info("\u67e5\u8be2\u6570\u636e\u5e93\uff0c\u5f85\u8ba4\u8bc1\u4eba\u5458\u6761\u6570:{};\u8be6\u60c5=[{}]", (Object)authRequestDtos.size(), (Object)authRequestDtos.stream().map(ii -> String.format("'%s'", ii.getIdNumber())).collect(Collectors.joining(",")));
            if (!CollectionUtils.isEmpty(authRequestDtos)) {
                ArrayList pageAuthRequests = new ArrayList();
                ArrayList<AuthRequestDto> perPageAuthRequests = null;
                for (int index = 0; index < authRequestDtos.size(); ++index) {
                    if (index % 10 == 0) {
                        perPageAuthRequests = new ArrayList<AuthRequestDto>();
                        pageAuthRequests.add(perPageAuthRequests);
                    }
                    perPageAuthRequests.add(authRequestDtos.get(index));
                }
                pageAuthRequests.parallelStream().forEach(limitAuthUsers -> {
                    Exception lastException = null;
                    try {
                        this.check((List<AuthRequestDto>)limitAuthUsers);
                    }
                    catch (Exception e) {
                        try {
                            lastException = e;
                        }
                        catch (Throwable throwable) {
                            logger.error("{}:\u5b8c\u6210\u6267\u884c\u5b9e\u540d\u8ba4\u8bc1--\u5f85\u8ba4\u8bc1\u7684\u4eba\u5458:{}", new Object[]{lastException == null ? "\u6210\u529f" : "\u5f02\u5e38", limitAuthUsers.stream().map(ii -> String.format("'%s'", ii.getIdNumber())).collect(Collectors.joining(",")), lastException});
                            throw throwable;
                        }
                        logger.error("{}:\u5b8c\u6210\u6267\u884c\u5b9e\u540d\u8ba4\u8bc1--\u5f85\u8ba4\u8bc1\u7684\u4eba\u5458:{}", new Object[]{lastException == null ? "\u6210\u529f" : "\u5f02\u5e38", limitAuthUsers.stream().map(ii -> String.format("'%s'", ii.getIdNumber())).collect(Collectors.joining(",")), lastException});
                    }
                    logger.error("{}:\u5b8c\u6210\u6267\u884c\u5b9e\u540d\u8ba4\u8bc1--\u5f85\u8ba4\u8bc1\u7684\u4eba\u5458:{}", new Object[]{lastException == null ? "\u6210\u529f" : "\u5f02\u5e38", limitAuthUsers.stream().map(ii -> String.format("'%s'", ii.getIdNumber())).collect(Collectors.joining(",")), lastException});
                });
                return true;
            }
            logger.info("\u88ab\u7b5b\u4eba\u5458\u5217\u8868\u4e3a\u7a7a");
            return false;
        }
        catch (Exception e) {
            logger.error("\u6267\u884c\u5b9e\u540d\u8ba4\u8bc1\u65b9\u6cd5-\u53d1\u751f\u5f02\u5e38:{}", (Throwable)e);
            return false;
        }
    }

    private List<AuthRequestDto> getPendingBgScreenUsers() {
        String sql = this.findUnAuthSql();
        logger.info("\u5f85\u67e5\u8be2\u7684\u4eba\u5458SQL={}", (Object)sql);
        return this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(AuthRequestDto.class));
    }

    private Result<List<AuthLog>> doExecute(Collection<AuthRequestDto> authRequestDtos) {
        return this.authFactory.getAuthByType().auth(authRequestDtos);
    }

    protected void check(List<AuthRequestDto> authRequestDtos) {
        block6: {
            try {
                Result<List<AuthLog>> result = this.doExecute(authRequestDtos);
                if ("0".equals(result.getRetType())) {
                    if (result.getData() == null) {
                        throw new SaasBadException(String.format("AuthenticationServiceAbstractImpl:Request interface message returns exception,ErrMsg:%s.", result.getMsg()));
                    }
                    List<AuthLog> list = result.getData();
                    if (list.size() > 0) {
                        for (AuthLog authlog : list) {
                            this.updateAuthResult(authlog);
                        }
                        logger.info("\u8ba4\u8bc1\u7ed3\u679c\u4e3a:{}", (Object)list.stream().map(ii -> String.format("\u8eab\u4efd\u8bc1=%s;\u7ed3\u679c=%s", ii.getIdNumber(), ii.getAuthResult())).collect(Collectors.joining(";")));
                    }
                    break block6;
                }
                throw new SaasBadException(String.format("AuthenticationServiceAbstractImpl:Request interface failed,ErrMsg:%s.", result.getMsg()));
            }
            catch (Exception e) {
                logger.error("\u5b9e\u540d\u8ba4\u8bc1\u51fa\u73b0\u5f02\u5e38:\u4eba\u5458={}" + authRequestDtos.stream().map(ii -> ii.getIdNumber()).collect(Collectors.joining(",")), (Throwable)e);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateAuthResult(AuthLog authlog) {
        String sql2 = "UPDATE bg_screening_users SET `authenticated_status`=?,`authenticated_time`=NOW(), `last_modified_time`=NOW(),`authenticated_result`= ? WHERE `idnum` = ?";
        this.jdbcTemplate.update(sql2, new Object[]{authlog.getAuthStatus(), authlog.getAuthResult(), authlog.getIdNumber()});
    }

    private void addProblemPeople(List<String> problemidnums, Map<String, String> problemMap) {
        String problemSql = "SELECT bs.idnum as 'idNumber' ,tm.domainid as 'domain_id',tm.item_domain_id as 'organization_id',tm.item_companyName as 'companyName',tm.ITEM_entryDate as 'entryTime', tm.ITEM_phone as 'phone',bs.`name` as 'securityName' ,bs.one_inch_color_white_photo as 'imgPath', (SELECT ifnull(ts.ITEM_registerPoliceAddress,'') FROM tlk_setsupervise ts WHERE ts.item_domain_id = tm.ITEM_DOMAIN_ID limit 1)  as registerPoliceAddress,(SELECT ifnull(ts.ITEM_registerPoliceAddressID,'') FROM tlk_setsupervise ts WHERE ts.item_domain_id = tm.ITEM_DOMAIN_ID limit 1)  as registerPoliceAddressID FROM tlk_securityman tm INNER JOIN bg_screening_users bs ON LEFT (tm.ID, LENGTH(bs.user_id)) = bs.user_id WHERE tm.ITEM_documentID in (" + problemidnums.toString().replace("[", "").replace("]", "") + ") AND tm.ITEM_isInMyCompany = 1;";
        System.err.println("\u67e5\u8be2\u6570\u636e\u5e93\uff0c\u9700\u8981\u6dfb\u52a0\u95ee\u9898\u4eba\u5458sql\uff1a" + problemSql);
        List problemList = this.jdbcTemplate.query(problemSql, (RowMapper)BeanPropertyRowMapper.newInstance(AuthLog.class));
        System.err.println("\u67e5\u8be2\u6570\u636e\u5e93\uff0c\u9700\u8981\u6dfb\u52a0\u95ee\u9898\u4eba\u5458\u6761\u6570\uff1a" + problemList.size());
        if (problemList.size() > 0) {
            StringBuilder sb = new StringBuilder();
            List<String> argList = Collections.synchronizedList(new ArrayList());
            sb.append("INSERT INTO bg_screening_user_results (ID,TYPE,CREATED,lastmodified,firstcompareTime,DOMAINID,QUESTIONTYPE,SECURITYNAME,DOCUMENTID,PHONE,COMPANYNAME,DOMAIN_ID,REGISTERPOLICEADDRESS,REGISTERPOLICEADDRESSID,POLICESTATUS,WORKSTATUS,COMPANYSTATUS,Entry_Time,COMPARETIME) values");
            for (AuthLog authlog : problemList) {
                String eTime = "'" + authlog.getEntryTime() + "'";
                if (StringUtils.isEmpty((Object)authlog.getEntryTime())) {
                    eTime = null;
                }
                String rpa = "'" + authlog.getRegisterPoliceAddress() + "'";
                if (StringUtils.isEmpty((Object)authlog.getRegisterPoliceAddress())) {
                    rpa = null;
                }
                String rpai = "'" + authlog.getRegisterPoliceAddressID() + "'";
                if (StringUtils.isEmpty((Object)authlog.getRegisterPoliceAddressID())) {
                    rpai = null;
                }
                String phone = "'" + authlog.getPhone() + "'";
                if (StringUtils.isEmpty((Object)authlog.getPhone())) {
                    phone = null;
                }
                String cn = "'" + authlog.getCompanyName() + "'";
                if (StringUtils.isEmpty((Object)authlog.getCompanyName())) {
                    cn = null;
                }
                String un = "'" + authlog.getSecurityName() + "'";
                if (StringUtils.isEmpty((Object)authlog.getSecurityName())) {
                    un = null;
                }
                String cid = "'" + authlog.getOrganization_id() + "'";
                if (StringUtils.isEmpty((Object)authlog.getOrganization_id())) {
                    cid = null;
                }
                String domainid = "'" + authlog.getDomain_id() + "'";
                if (StringUtils.isEmpty((Object)authlog.getDomain_id())) {
                    domainid = null;
                }
                String sql = "( UUID_SHORT() ,'4', NOW(),NOW(), NOW()," + domainid + " , '" + problemMap.get(authlog.getIdNumber()) + "'," + un + ",'" + authlog.getIdNumber() + "', " + phone + "," + cn + "," + cid + ", " + rpa + "," + rpai + ",0,1,0," + eTime + ",NOW() )";
                argList.add(sql);
            }
            sb.append(argList.toString().replace("[", "").replace("]", ";"));
            System.err.println("\u6dfb\u52a0\u95ee\u9898\u4eba\u5458sql\uff1a" + sb.toString());
            this.jdbcTemplate.update(sb.toString());
        }
    }
}

