/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.syncs.services.impls;

import com.bcxin.backend.domain.syncs.events.SyncDataApplicationEvent;
import com.bcxin.backend.domain.syncs.repositories.DataSyncQueueRepository;
import com.bcxin.backend.domain.syncs.services.RetryDataService;
import com.bcxin.runtime.domain.syncs.entities.DataSyncQueueEntity;
import com.bcxin.runtime.domain.syncs.enums.SyncProcessStatus;
import java.util.Date;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class RetryDataServiceImpl
implements RetryDataService {
    private final DataSyncQueueRepository dataSyncQueueRepository;
    private final ApplicationEventPublisher applicationEventPublisher;

    public RetryDataServiceImpl(DataSyncQueueRepository dataSyncQueueRepository, ApplicationEventPublisher applicationEventPublisher) {
        this.dataSyncQueueRepository = dataSyncQueueRepository;
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @Override
    public void retrySync() {
        try {
            Page<DataSyncQueueEntity> dataSyncQueueEntities = this.dataSyncQueueRepository.getRetryableQueueData(Pageable.ofSize((int)100));
            dataSyncQueueEntities.forEach(ii -> ii.retry(String.format("\u6267\u884c\u540c\u6b65\u6570\u636e\u7684\u91cd\u8bd5\u64cd\u4f5c:%s", new Date())));
            this.dataSyncQueueRepository.saveAll((Iterable)dataSyncQueueEntities);
            dataSyncQueueEntities = this.dataSyncQueueRepository.getRetryableQueueFile(Pageable.ofSize((int)100));
            dataSyncQueueEntities.forEach(ii -> ii.changeFileSyncStatusAndRetryCount(ii.getStatus() == SyncProcessStatus.Error ? SyncProcessStatus.Initialize : SyncProcessStatus.SyncViaFTP, ii.getFileSyncResult()));
            this.dataSyncQueueRepository.saveAll((Iterable)dataSyncQueueEntities);
        }
        finally {
            this.applicationEventPublisher.publishEvent((ApplicationEvent)SyncDataApplicationEvent.create("\u91cd\u8bd5\u540c\u6b65\u6570\u636e"));
        }
    }
}

