/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.syncs.components;

import com.bcxin.backend.core.utils.ExceptionUtils;
import com.bcxin.backend.domain.syncs.components.IFormDataExporter;
import com.bcxin.backend.domain.system.configs.DispatchSiteResourceProperties;
import com.bcxin.event.enums.EventAction;
import com.bcxin.event.repositories.EventSourceRepository;
import com.bcxin.runtime.domain.metas.entities.DataSourceMetaEntity;
import com.bcxin.runtime.domain.metas.entities.FormMetaEntity;
import com.bcxin.runtime.domain.metas.entities.FormSyncMetaEntity;
import com.bcxin.runtime.domain.snapshoots.JdbcConnectionSnapshot;
import com.bcxin.runtime.domain.syncs.dtos.DataSetDto;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.saas.core.exceptions.SaasBadException;
import com.bcxin.saas.core.exceptions.SaasNofoundException;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class FormDataExporterImpl
implements IFormDataExporter {
    private static final Logger logger = LoggerFactory.getLogger(FormDataExporterImpl.class);
    public static final int PAGE_SIZE = 20;
    public static final String SYNC_DEPARTMENT_VIEW = "sync_department_view";
    private static Map<String, DataSource> dataSourceMap = new ConcurrentHashMap<String, DataSource>();
    private final JsonProvider jsonProvider;
    private final EventSourceRepository eventSourceRepository;
    private final DispatchSiteResourceProperties dispatchSiteResourceProperties;
    private static Map<String, Collection<DataSetDto.Column>> cache_MetaTableColumns = new ConcurrentHashMap<String, Collection<DataSetDto.Column>>();

    public FormDataExporterImpl(JsonProvider jsonProvider, EventSourceRepository eventSourceRepository, DispatchSiteResourceProperties dispatchSiteResourceProperties) {
        this.jsonProvider = jsonProvider;
        this.eventSourceRepository = eventSourceRepository;
        this.dispatchSiteResourceProperties = dispatchSiteResourceProperties;
    }

    @Override
    public DataSetDto export(FormSyncMetaEntity formSyncMetaEntity, Timestamp startDateTime, int pageIndex) {
        DataSource dataSource = this.buildDataSource(formSyncMetaEntity.getFormMeta());
        try {
            return this.getDataSet(formSyncMetaEntity, dataSource, startDateTime, pageIndex);
        }
        catch (SQLException ex) {
            throw new SaasBadException(String.format("FormData \u5bfc\u51fa\u5f02\u5e38:%s", ExceptionUtils.getStackMessage((Throwable)ex)), (Exception)ex);
        }
    }

    private String buildSql(FormSyncMetaEntity formSyncMetaEntity, String connectionJdbcUrl, Timestamp startDateTime, int pageIndex) {
        int pageSize = 0;
        pageSize = SYNC_DEPARTMENT_VIEW.equalsIgnoreCase(formSyncMetaEntity.getFormMeta().getTableName()) ? 200 : 20;
        String pagedSql = String.format(" offset %s limit %s", pageIndex * pageSize, pageSize);
        if (connectionJdbcUrl.contains("mysql:")) {
            pagedSql = String.format(" limit %s,%s", pageIndex * pageSize, pageSize);
        }
        String condition = "";
        if (StringUtils.hasLength((String)formSyncMetaEntity.getFilter())) {
            condition = formSyncMetaEntity.getFilter();
        }
        Timestamp startTime = startDateTime;
        String sql = null;
        sql = SYNC_DEPARTMENT_VIEW.equalsIgnoreCase(formSyncMetaEntity.getFormMeta().getTableName()) ? String.format("SELECT * FROM (select * from %s where LASTMODIFIED>='%s' %s) AS A ORDER BY LEVEL ASC %s ", formSyncMetaEntity.getFormMeta().getTableName(), startTime, condition, pagedSql) : String.format("SELECT * FROM (select * from %s where LASTMODIFIED>='%s' %s) AS A ORDER BY LASTMODIFIED ASC %s ", formSyncMetaEntity.getFormMeta().getTableName(), startTime, condition, pagedSql);
        return sql;
    }

    private DataSource buildDataSource(FormMetaEntity formMetaEntity) {
        DataSourceMetaEntity dataSourceMetaEntity = formMetaEntity.getDefaultDataSource();
        if (dataSourceMetaEntity == null) {
            throw new SaasNofoundException(String.format("\u540c\u6b65\u8868%s\u627e\u4e0d\u5230\u6570\u636e\u6e90\uff0c\u8003\u8651\u5916\u952e\u5173\u8054meta_datasources\u662f\u5426\u6709\u95ee\u9898", formMetaEntity.getTableName()));
        }
        JdbcConnectionSnapshot snapshot = (JdbcConnectionSnapshot)this.jsonProvider.getData(dataSourceMetaEntity.getConfig(), JdbcConnectionSnapshot.class);
        String dataSourceKey = String.format("url:%s-username:%s-ps:%s", snapshot.getUrl(), snapshot.getUsername(), snapshot.getPassword());
        DataSource dataSource = dataSourceMap.get(dataSourceKey);
        if (dataSource == null) {
            String jdbcUrl = snapshot.getUrl();
            if ("com.mysql.jdbc.Driver".equals(snapshot.getDriverClass())) {
                snapshot.setDriverClass("com.mysql.cj.jdbc.Driver");
            }
            HikariDataSource hikariDataSource = new HikariDataSource();
            hikariDataSource.setJdbcUrl(jdbcUrl);
            hikariDataSource.setUsername(snapshot.getUsername());
            hikariDataSource.setPassword(snapshot.getPassword());
            hikariDataSource.setDriverClassName(snapshot.getDriverClass());
            dataSource = hikariDataSource;
            dataSourceMap.put(dataSourceKey, dataSource);
        }
        return dataSource;
    }

    /*
     * Exception decompiling
     */
    private DataSetDto getDataSet(FormSyncMetaEntity formSyncMetaEntity, DataSource dataSource, Timestamp startDateTime, int pageIndex) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Object getColumnValue(ResultSet resultSet, String columnName) {
        Object columnValue = null;
        try {
            columnValue = resultSet.getObject(columnName);
        }
        catch (Exception ex) {
            try {
                logger.error(String.format("\u5b57\u6bb5(%s)\u53d6\u6570\u5f02\u5e38:%s; \u5ffd\u7565-\u660e\u7ec6:%s", columnName, resultSet.getString(columnName), ExceptionUtils.getStackMessage((Throwable)ex)));
            }
            catch (Exception exx) {
                exx.printStackTrace();
            }
            columnValue = null;
        }
        return columnValue;
    }

    private List<String> getDeletedIds(FormSyncMetaEntity formSyncMetaEntity, Date beginDate, Date endDate) {
        Collection eventSourceEntities = this.eventSourceRepository.findAll(EventAction.Deleted, formSyncMetaEntity.getFormMeta().getFormId(), beginDate, endDate);
        return eventSourceEntities.stream().map(ii -> ii.getRecordId()).collect(Collectors.toList());
    }

    private Timestamp getNextSectionDate(Timestamp fetchModifiedTime) {
        Timestamp endFetchedModifiedTime;
        Instant fetchedModifiedTimeInstant = Instant.ofEpochMilli(fetchModifiedTime.getTime());
        fetchedModifiedTimeInstant = fetchedModifiedTimeInstant.isBefore(Instant.now().minus(1825L, ChronoUnit.DAYS)) ? fetchedModifiedTimeInstant.minus(-2190L, ChronoUnit.DAYS) : fetchedModifiedTimeInstant.minus(-60L, ChronoUnit.DAYS);
        if (fetchedModifiedTimeInstant.isBefore((endFetchedModifiedTime = Timestamp.from(Instant.now())).toInstant())) {
            endFetchedModifiedTime = Timestamp.from(fetchedModifiedTimeInstant);
        }
        return endFetchedModifiedTime;
    }

    private Collection<DataSetDto.Column> getTableMetaColumns(String connectionJdbcUrl, ResultSetMetaData metaData) throws SQLException {
        String tableName = metaData.getTableName(1);
        String tableColumnCacheKey = String.format("url=%s;table=%s", connectionJdbcUrl, tableName);
        Collection<DataSetDto.Column> columns = cache_MetaTableColumns.get(tableColumnCacheKey);
        if (columns == null) {
            columns = new ArrayList<DataSetDto.Column>();
            for (int colIndex = 1; colIndex <= metaData.getColumnCount(); ++colIndex) {
                columns.add(DataSetDto.Column.create((String)metaData.getColumnName(colIndex)));
            }
            cache_MetaTableColumns.put(tableColumnCacheKey, columns);
        }
        return columns;
    }

    private static /* synthetic */ boolean lambda$getDataSet$5(Object ii) {
        return ii != null;
    }

    private /* synthetic */ Object lambda$getDataSet$4(ResultSet resultSet, DataSetDto.Column ii) {
        return this.getColumnValue(resultSet, ii.getName());
    }

    private static /* synthetic */ boolean lambda$getDataSet$3(DataSetDto.Column ii) {
        return ii.isDomainId();
    }

    private static /* synthetic */ boolean lambda$getDataSet$2(Object ii) {
        return ii != null;
    }

    private /* synthetic */ Object lambda$getDataSet$1(ResultSet resultSet, DataSetDto.Column ii) {
        return this.getColumnValue(resultSet, ii.getName());
    }

    private static /* synthetic */ boolean lambda$getDataSet$0(DataSetDto.Column ii) {
        return ii.isId();
    }
}

