/**
 * @function 表格页面重复逻辑的抽离
 * @author Lyq（2020-04-28）
 * @param option Object
 *        search重置原有的search方法
 *        type: saas 表格调用的接口模式
 * 
 * 
 * @props setParams: Function --> function(values){}
 *                传入表格页面的页面的参数用于更新表格和初始化表格
 * @props updateTable: Function -->  function(){}
 *                调用直接更新表格
 * @props isInit Boolean 
 *                表格是否初始化的标识，只有pageNumber和pageSize参数的表格页面可以使用this.props.setHOCState({isInit: true})来直接初始化
 * @props PageTable Component 
 *                表格组件
 * @props SearchForm Component 
 *                搜索组件
 *                arrange: Function(values) --> 用于将表单的值整理成想要的值并且返回回去
 *                         values是表单组件获取到的字段集合
 *       
 */

import React, { Component } from "react";
// import BTable from '../../components/Pro/BTable';
import PTable from '../../components/Pro/PTable';
import {
  Form,
  Button
} from "antd";

// 搜索组件
class SearchForm extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
    };
  }
  componentDidMount() {
    this._search(undefined, false);
  }
  _search = (e, clicked) => {
    e && e.preventDefault();
    this.props.form.validateFields((err, values) => {
      if (err) return;
      // 整理参数
      try {
        values = this.props.arrange? this.props.arrange(JSON.parse(JSON.stringify(values))): values;
      } catch (ex) {
        log(ex, 'tablepage err');
      }
      // 搜索的时候重置为第一页
      values.pageNumber = 1;
      // 传递参数  //clicked搜索按钮是否被点击, 用于导出功能的开发
      this.props.onSearch && this.props.onSearch(values, clicked);
    });
  }
  _reset = () => {
    this.props.form.resetFields();
    this._search(undefined, false);
  }
  render() {
    const renderBtns = () => {
      if(this.props.Btns) {
        const Btns = this.props.Btns;  //样式组件
        return (
          <Btns>
            <Form.Item label="" colon={false}>
              <Button type="primary" onClick={e => {
                this._search(e, true);
                this.props.onSearchClick && this.props.onSearchClick();
              }}>搜索</Button>
            </Form.Item>
            <Form.Item label="" colon={false}>
              <Button onClick={this._reset}>重置</Button>
            </Form.Item>
          </Btns>
        );
      }else {
        return (
          <>
            <Form.Item label="" colon={false}>
              <Button type="primary" onClick={e => {
                this.props.onSearchClick && this.props.onSearchClick();
                this._search(e, true);
              }}>搜索</Button>
            </Form.Item>
            <Form.Item label="" colon={false}>
              <Button style={{ marginLeft: 15 }} onClick={this._reset}>重置</Button>
            </Form.Item>
          </>
        );
      }
    }
    return (

      <Form layout="inline" onSubmit={this._search}>
        {this.props.children}
        {renderBtns()}
      </Form>
    );
  }
}

export default function tablePage({ setParams, type } = {}) {
  return function (WrapComponent) {
    @Form.create()
    class PageComponent extends Component {
      constructor(props, context) {
        super(props, context);
        this.state = {
          forceUpdate: false, //刷新数据
          searchData: {  // 表格数据请求参数
            pageNumber: 1,  // 页	
            pageSize: 10  //条目
          },
          clicked: false, //clicked搜索按钮是否被点击, 用于导出功能的开发
          PageTable: function (props) {
            type = type || 'saas';
            // const TableComponent = type == 'saas' ? PTable : BTable;
            const TableComponent = PTable ;
            return (
              <TableComponent
                style={{ marginTop: 20 }}
                pageParm={this.state.searchData}
                forceUpdate={this.state.forceUpdate}
                {...props}
              />
            )
          }.bind(this),
          SearchForm: function (props) {
            return (
              <SearchForm
                onSearch={(values, clicked) => {
                  this._setParams(values);
                  if(!this.state.clicked && clicked) {
                    this.setState({clicked: true});
                  }
                }}
                form={this.props.form}
                {...props}
              />
            );
          }.bind(this),
          Form
        };
      }

      _setParams = (values) => {
        if (setParams) {
          setParams.call(this, values);
        } else {
          this.setState({
            searchData: {
              ...this.state.searchData,
              ...values
            },
            isInit: true
          });
        }
      }
      _updateTable = (params) => {
        // 如果传入了参数，更新searchData
        if (params) {
          this.setState({
            searchData: {
              ...this.state.searchData,
              ...params
            }
          });
        }
        
        // 触发表格重新渲染
        this.setState({
          forceUpdate: true
        }, () => {
          this.setState({
            forceUpdate: false
          });
        });
      }
      render() {
        return (
          <WrapComponent
            updateTable={this._updateTable}
            setHOCState={this.setState.bind(this)}
            {...this.props}
            {...this.state}
            Form={Form}
          />
        );
      }
    }
    return PageComponent;
  }
};