import { stringify } from 'qs';
import * as api_task from './api_task'; //任务管理
import {
  request,
  v5comRequest,
  saasDownloadBlob,
  // loginRequest,
  noLoginRequest,
} from '../utils/request';
import * as api_brachCompany from './api_brachCompany'; //总/子/分公司管理
import { getHostByPath } from '../utils/config';
import * as api_kaoQinGuanLi from './api_kaoQinGuanLi'; //内勤管理
import * as api_taskbuild from './api_taskbuild'; //驻勤管理
import * as apiLoginRegister from './api_loginRegister'; //登录注册
import * as apiMeeting from './api_meeting';//华为云会议
import * as apiBusinessAddressBook from './api_businessAddressBook'; //企业通讯录
import * as apiCommand from './api_command';//防控指挥
import * as apiWallet from './api_Wallet';//企业钱包
import * as apiInsurance from './api_insurance';//企业保险
//内勤管理
export const {
  attendanceGetShiftPage,
  attendanceDeleteShiftById,
  taskAttendanceComAttendGroupAddAttendGroup,
  taskAttendanceComAttendGroupFindAttendGroupById,
  taskAttendanceComAttendGroupUpdateAttendGroup,
  taskAttendanceComAttendGroupFindAttendGroupByPerId,
  taskAttendanceComAttendGroupPageForGroup,
  taskAttendanceComAttendGroupDelete,
  taskComShiftPage,
  taskAttendanceComAttendGroupFindAttendGroupByPerIdStr,
  taskAttendanceComattendgroupfixedSave,
  taskAttendanceComattendgroupfixedGetAddTemp,
  taskAttendanceComattendgroupfixedUpdate,
  taskAttendanceComattendgroupfixedGetDetail,
  taskAttendanceComAttendGroupListAttendGroupAddress,
  taskAttendanceComAttendGroupUpdateAttendGroupAddress,
  taskAttendanceComAttendGroupAddAttendGroupAddress,
  taskComShiftDelete,
  taskComShiftGet,
  taskComShiftInsert,
  taskComShiftUpdate,
  taskAttendanceComAttendGroupInFirstStepAttendGroup,
  taskAttendanceComAttendGroupSaveFirstStepAttendGroup,
  taskAttendanceComAttendGroupInSecondStepAttendGroup,
  taskAttendanceComAttendGroupSaveSecondStepAttendGroup,
  taskAttendanceComAttendGroupInThirdStepAttendGroup,
  taskAttendanceComAttendGroupSaveThirdStepAttendGroup,
  taskAttendanceComAttendGroupCheckAttendPer,
  getdayStatisticsData,
  getmonthStatisticsData,
  getDepartmentData,
  getAttendRecordDetail,
  changeRecordDetail
} = api_kaoQinGuanLi;

//任务管理
export const {
  taskBaseInfo,
  taskManagementAddTaskStepOne,
  taskComTaskPerShiftListShift,
  taskComTaskPerShiftListPerShift,
  taskComTaskPerShiftValidateSinglePerShift,
  taskComTaskPerShiftSetSinglePerShift,
  taskComTaskPerShiftResetSinglePerShift,
  taskComTaskPerShiftPagePerShift,
  getdayStatisticsDataTask,
  getmonthStatisticsDataTask,
  getAttendRecordDetailTask,
  changeRecordDetailTask,
  taskShiftAddTaskShift,
  taskShiftGetNoSetShiftList
} = api_task;



const host = getHostByPath();
export { host };


// 下载blob
export function enterpriseInsComInsExportErrInsPer(data) {
  return saasDownloadBlob('/enterprise/ins/com-ins/export-err-ins-per', data);
}


export async function queryTags() {
  return request('/api/tags');
}

export async function queryBasicProfile() {
  return request('/api/profile/basic');
}

export async function queryAdvancedProfile() {
  return request('/api/profile/advanced');
}

export async function queryFakeList(params) {
  return request(`/api/fake_list?${stringify(params)}`);
}

export async function fakeAccountLogin(params) {
  return request('/api/login/account', {
    method: 'POST',
    body: params
  });
}

export async function fakeMobileLogin(params) {
  return request('/api/login/mobile', {
    method: 'POST',
    body: params
  });
}

export async function fakeRegister(params) {
  return request('/api/register', {
    method: 'POST',
    body: params
  });
}

// 获取用户登陆菜单
export function systemOauthGetUserMenus(data) {
  return request('/oauth/get-user-menus', {
    method: 'GET',
    data
  });
}

// 修改企业基本信息
export function updateComBaseInfoById(data) {
  return request('/enterprise/company/com-base-info/update-com-base-info', {
    method: 'POST',
    data
  });
}
// 修改企业s手机号
export function updateComLegalRepPhone(data) {
  return request('/enterprise/company/com-auth-info/update-com-legal-rep-phone', {
    method: 'POST',
    data
  });
}

//获取人员类别
export function getPerType(data) {
  return request('/public/common/get-industry-dict-by-code-types', {
    method: 'POST',
    data
  });
}

// 获取企业详情
export function systemComVaseInfoGet(data) {
  return request('/company/get', {
    method: 'GET',
    data
  });
}

// 企业信息-认证申请查询
export function getCertificationData(data) {
  return request('/enterprise/company/com-auth-info/get-com-auth-info-by-id', {
    method: 'POST',
    data
  });
}
/**
 * 任务模块获得合同列表
 * @author Lyq
 */
export function getContractListByTask(data) {
  return request("/enterprise/com-contract/get-contract-list-by-task", {
    method: "POST",
    data: data || {}
  });
}
/**
 * 获取任务人员列表
 * @author Lyq
 */
export function taskGetTaskPer(data) {
  return request("/task/get-task-per", {
    method: "GET",
    data: data || {}
  });
}
/**
 * 获取任务负责人
 * @author Lyq
 */
export function getTaskChargePer(data) {
  return request("/task/get-task-charge-per", {
    method: "GET",
    data: data || {}
  });
}
/**
 * 移除任务人员
 * @author Lyq
 */
export function removeTaskPer(data) {
  return request("/task/remove-task-per", {
    method: "POST",
    data: data || {}
  });
}
/**
 * 新增任务人员
 * @author Lyq
 */
export function addTaskPer(data) {
  return request("/task/add-task-per", {
    method: "POST",
    data: data || {}
  });
}
/**
 * 修改任务负责人
 * @author Lyq
 */
export function updateTaskChargePer(data) {
  return request("/task/update-task-charge-per", {
    method: "POST",
    data: data || {}
  });
}
// 企业信息-认证申请-行业资质查询
export function enterpriseCompanyGetComIndustryinfo(data) {
  return request(
    '/enterprise/company/com-auth-info/get-com-industry-info-by-comid',
    {
      method: 'POST',
      data
    }
  );
}

//分公司、子公司通过ID获得企业行业信息
export function enterpriseCompanyComIndustryGetComBranchIndustryInfoByComId(
  data
) {
  return request(
    '/enterprise/company/com-industry/get-com-branch-industry-info-by-comid',
    {
      method: 'GET',
      data
    }
  );
}

//省市区
export function getDistrictData() {
  return noLoginRequest('/public/common/region/get-regions', {
    method: 'POST',
    data: {}
  });
}

//省市区的代码换算中文
export function getDistrictChineseData(data) {
  return noLoginRequest('/public/common/region/get-region-by-id', {
    method: 'POST',
    data
  });
}

//修改企业认证信息
export function enterpriseCompanyUpdateComAuthInfo(data) {
  return request('/enterprise/company/com-auth-info/update-com-auth-info', {
    method: 'POST',
    data
  });
}

export function modifyComInformation(data) {
  return request('/enterprise/company/update-com-auth-info', {
    method: 'POST',
    data
  });
}

//手机验证===发送法人手机验证码
export function enterpriseCompanySendLegalAuthCode(data) {
  return request('/enterprise/company/com-auth-info/send-legal-auth-code', {
    method: 'POST',
    data
  });
}

// 获得企业报表列表
export function enterpriseSalaryComReportCompanyReportList(data) {
  return request('/enterprise/salary/com-report/company-report-list', {
    method: 'POST',
    data
  });
}

//手机验证===验证验证码，检查手机验证码和企业ID是否匹配，10分钟后验证码过期
export function enterpriseComAuthInfoCheckLegalAuthCode(data) {
  return request('/enterprise/company/com-auth-info/check-legal-auth-code', {
    method: 'POST',
    data
  });
}

//企业信息-认证申请-获得企业机构特殊信息
export function enterpriseCompanyComIndustryGetIndustryConfigByComId(data) {
  return request(
    '/enterprise/company/com-industry/get-industryconfig-by-comId',
    {
      method: 'GET',
      data
    }
  );
}

//根据企业ID获得企业发票信息
export function getCompanyVnvoiceInfo(data) {
  return request('/enterprise/company/com-invoice/get-company-invoice-info', {
    method: 'POST',
    data
  });
}

//保存企业发票信息
export function saveCompanyInvoiceInfo(data) {
  return request('/enterprise/company/com-invoice/save-company-invoice-info', {
    method: 'POST',
    data
  });
}

//修改企业发票信息
export function updateCompanyInvoiceInfo(data) {
  return request(
    '/enterprise/company/com-invoice/update-company-invoice-info',
    {
      method: 'POST',
      data
    }
  );
}

//文件上传服务
export const uploadUrl =getHostByPath('v5common') + '/identify/api/common/upload-file';
//文件语音发送上传服务
export const blobuploadUrl =getHostByPath('v5common') + '/identify/api/common/upload-blob-file';

// 文件上传服务
export function publicCommonFileUploadFile(data, loading = true) {
  return v5comRequest('/identify/api/common/upload-file', {
    method: 'POST',
    data,
    headers: {
      "Content-Type": "multipart/form-data"
    }
  }, null, false, loading);
}
//批量导入在保人员减员
export function enterpriseInsComInsMinusBatchUploadInsPer(data, loading = true) {
  return request('/enterprise/ins/com-ins/minus-batch-upload-ins-per', {
    method: 'POST',
    data,
    headers: {
      "Content-Type": "multipart/form-data"
    }
  }, null, false, loading);
}

// 查询数据字典接口
export function insComInsSaveAuthFile(data) {
  return noLoginRequest('/enterprise/ins/com-ins/save-auth-file', {
    method: 'POST',
    data
  });
}
//文件读取服务
export function publicCommonFileGetResource(data) {
  return noLoginRequest('/public/common/file/get-resource', {
    method: 'GET',
    data
  });
}

//文件预览转换
export function publicCommonFileFilePreview(data) {
  return noLoginRequest('/public/common/file/filePreview', {
    method: 'POST',
    data
  });
}

// 查询数据字典接口
export function publicCommonDictGetDictByCodeTypes(data) {
  return request('/public/common/get-dict-by-code-types', {
    method: 'POST',
    data
  });
}

// 根据行业类型获取机构
export function publicCommonDictGetInstitutionTypeByIndustryType(data) {
  return noLoginRequest(
    '/public/common/get-institution-type-by-industry-type',
    {
      method: 'POST',
      data
    }
  );
}

// 删除报表
export function enterpriseSalaryComReportDeleteCompanyReport(data) {
  return request('/enterprise/salary/com-report/delete-company-report', {
    method: 'POST',
    data
  });
}

// 获取报表表头字段集合
export function enterpriseSalaryComReportReportFieldList(data) {
  return request('/enterprise/salary/com-report/report-field-list', {
    method: 'POST',
    data
  });
}

// 新建企业自定义报表
export function enterpriseSalaryComReportAddCompanyReport(data) {
  return request('/enterprise/salary/com-report/add-company-report', {
    method: 'POST',
    data
  });
}

//医社保记录统计
export function statHisRecList(data) {
  return request('/enterprise/ins/medical-social-rec/stat-his-rec-list', {
    method: 'POST',
    data
  });
}

//提示用户去完成方案的设置
export function promptUserToSetScheme(data) {
  return request(
    '/enterprise/ins/medical-social-rec/prompt-user-to-set-scheme',
    {
      method: 'GET',
      data
    }
  );
}

//医社保记录，导出excel
export function exportHisRecList(data) {
  return request('/enterprise/ins/medical-social-rec/export-his-rec-list', {
    method: 'GET',
    data
  });
}

//医社保记录，查询人员缴交情况分页
export function getHisRecListPage(data) {
  return request('/enterprise/ins/medical-social-rec/get-his-rec-list-page', {
    method: 'POST',
    data
  });
}

//缴交设置列表，查询人员缴交情况分页
export function getPaymentSettingListPage(data) {
  return request(
    '/enterprise/ins/payment-setting-list/get-payment-setting-list-page',
    {
      method: 'POST',
      data
    }
  );
}

//删除缴交方案
export function delPaymentSetting(data) {
  return request('/enterprise/ins/payment-setting-list/del-payment-setting', {
    method: 'POST',
    data
  });
}

//缴交方案详情查询，通过缴交方案ID
export function getPaymentSettingById(data) {
  return request('/enterprise/ins/payment-setting/get-payment-setting-by-id', {
    method: 'POST',
    data
  });
}

//缴交方案的已选人员列表
export function getSelectedPersonPage(data) {
  return request('/enterprise/ins/payment-setting/get-selected-person-page', {
    method: 'POST',
    data
  });
}

//移除人员，删除关系数据
export function paymentSettingDelPerson(data) {
  return request('/enterprise/ins/payment-setting/del-person', {
    method: 'POST',
    data
  });
}

//添加人员，增加关系数据
export function paymentSettingAddPerson(data) {
  return request('/enterprise/ins/payment-setting/add-person', {
    method: 'POST',
    data
  });
}

//缴交方案新增或修改
export function paymentSettingSavePaymentSetting(data) {
  return request('/enterprise/ins/payment-setting/save-payment-setting', {
    method: 'POST',
    data
  });
}

//分页消息列表（收件人方）
export function messageReceiveList(data) {
  return request('/public/message/page-message-list', {
    method: 'POST',
    data
  });
}

//分页查询升级消息列表
export function getConfigUpdateMsgList(data) {
  return request('/enterprise/company/upgrade/get-config-update-msg-list', {
    method: 'POST',
    data
  });
}

//当前用户-批量删除消息(发送记录)
export function messageDeleteSendMessage(data) {
  return request('/public/message/send/batch-delete', {
    method: 'POST',
    data
  });
}

//根据消息关联id删除消息
export function messageDeleteMessageById(data) {
  return request('/public/message/batch-delete', {
    method: 'POST',
    data
  });
}


//根据消息关联id查询具体消息详情
export function messagegetmessagebyid(data) {
  return request('/public/message/message-detail', {
    method: 'POST',
    data
  });
}

//保存消息-企业消息------改成罗鹏的接口
export function messageSaveMessageCommon(data) {
  return request('/public/message/save-message', {
    method: 'POST',
    data
  });
}

//当前用户获取消息记录列表
export function messageRecordList(data) {
  return request('/public/message/page-send-message-list', {
    method: 'POST',
    data
  });
}

//校验是否存在有效的保安员资格证
export function checkIsExistsEffectBayzgz(data) {
  return request('/per-cer-baseinfo/check-is-exists-effect-bayzgz', {
    method: 'POST',
    data
  });
}

export function getConfigUpdateMsgInfo(data) {
  return request('/enterprise/company/upgrade/get-config-update-msg-info', {
    method: 'POST',
    data
  });
}

//股权变更（预览校验）
export function comStockChangeSharePreview(data) {
  return request('/enterprise/stock/com-stock/change-share-preview', {
    method: 'POST',
    data
  });
}

//股权变更（保存）
export function saveComStockChangeShare(data) {
  return request('/enterprise/stock/com-stock/change-share', {
    method: 'POST',
    data
  });
}


//获取当前登陆用户账号信息
export function systemPerAccountInfoGetUserAccount(data) {
  return request('/per-account-info/get-user-account', {
    method: 'GET',
    data
  });
}

//------------------------股东end------------------ 获取跨区经营列表
export function comStockCrossManageList(data) {
  return request('/enterprise/stock/submit/com-stock/cross-manage-list', {
    method: 'POST',
    data
  });
}

//根据ID删除跨区经营信息
export function comStockDeleteCrossManageById(data) {
  return request(
    '/enterprise/stock/submit/com-stock/delete-cross-manage-by-id',
    {
      method: 'POST',
      data
    }
  );
}

//根据ID获取跨区经营信息
export function comStockGetCrossManageById(data) {
  return request('/enterprise/stock/submit/com-stock/get-cross-manage-by-id', {
    method: 'POST',
    data
  });
}

//保存-修改跨区经营
export function comStockSaveCrossManage(data) {
  return request('/enterprise/stock/submit/com-stock/save-cross-manage', {
    method: 'POST',
    data
  });
}

//获取海外经营列表
export function comStockComOverseaManageList(data) {
  return request('/enterprise/stock/submit/com-stock/com-oversea-manage-list', {
    method: 'POST',
    data
  });
}

//根据ID删除海外经营信息
export function comStockDeleteOverseaManageById(data) {
  return request(
    '/enterprise/stock/submit/com-stock/delete-oversea-manage-by-id',
    {
      method: 'POST',
      data
    }
  );
}

//获取海外经营信息
export function comStockGetOverseaManageById(data) {
  return request(
    '/enterprise/stock/submit/com-stock/get-oversea-manage-by-id',
    {
      method: 'POST',
      data
    }
  );
}

//保存-修改海外经营
export function stockSubmitComStockSaveOverseaManage(data) {
  return request('/enterprise/stock/submit/com-stock/save-oversea-manage', {
    method: 'POST',
    data
  });
}

//保存-修改管理层
export function submitComStockSaveComManage(data) {
  return request('/enterprise/stock/submit/com-stock/save-com-manage', {
    method: 'POST',
    data
  });
}

//获取管理员列表-liyongqiang
export function comStockManageList(data) {
  return request('/enterprise/stock/submit/com-stock/com-manage-list', {
    method: 'POST',
    data
  });
}

//根据id删除管理员信息-liyongqiang
export function comStockDeleteManageById(data) {
  return request('/enterprise/stock/submit/com-stock/delete-com-manage-by-id', {
    method: 'POST',
    data
  });
}

//获取管理员信息-liyongqinag
export function comStockGetManageById(data) {
  return request('/enterprise/stock/submit/com-stock/get-com-manage-by-id', {
    method: 'POST',
    data
  });
}

//获取管理层变更信息列表-liyongqiang
export function comStockChangeManageList(data) {
  return request('/enterprise/stock/submit/com-stock/change-manage-list', {
    method: 'POST',
    data
  });
}

//获取在职管理员的列表（人员选择下拉列表）
export function comStockComManageListByStatus(data) {
  return request(
    '/enterprise/stock/submit/com-stock/com-manage-list-by-status',
    {
      method: 'POST',
      data
    }
  );
}

//替换-新管理员代替旧管理员
export function comStockSaveReplaceComManage(data) {
  return request('/enterprise/stock/submit/com-stock/save-replace-com-manage', {
    method: 'POST',
    data
  });
}

//获取管理员信息
export function comStockGetComManageById(data) {
  return request('/enterprise/stock/submit/com-stock/get-com-manage-by-id', {
    method: 'POST',
    data
  });
}

//获取主管理员信息
export function selectComAdmin(data) {
  return request('/per-account-info/select-com-admin', {
    method: 'POST',
    data
  });
}

//更改主管理员
export function changeComAdmin(data) {
  return request('/com-admin-change-event/update', {
    method: 'POST',
    data
  });
}


/**********************************************合同******************************************/

/**
 * 合同管理-获取合同列表
 * @author CXL
 */
export function checkRelateTaskByContractId(data) {
  return request('/task/check-relate-task-by-contract-id', {
    method: 'POST',
    data
  });
}
/**
 * 合同管理-导出合同列表
 * @author CXL
 */
export function exportContractList(data) {
  return request('/enterprise/com-contract/export-contract-list', {
    method: 'GET',
    data
  });
}
export function enterpriseComContractComContractList(data) {
  return request('/enterprise/com-contract/com-contract-list', {
    method: 'POST',
    data
  });
}
// 获取即将到期的合同数量
export function getExpireContractCount(data) {
  return request('/enterprise/com-contract/get-expire-contract-count', {
    method: 'GET',
    data
  });
}

/**
 * 合同管理-删除合同
 * @author CXL
 */
export function enterpriseComContractDeleteComContract(data) {
  return request('/enterprise/com-contract/delete-com-contract', {
    method: 'POST',
    data
  });
}

/**
 * 合同管理-终止合同
 * @author CXL
 */
export function enterpriseComContractTerminationComContract(data) {
  return request('/enterprise/com-contract/termination-com-contract', {
    method: 'POST',
    data
  });
}

/**
 * 合同管理-通过ID获得合同信息
 * @author CXL
 */
export function enterpriseComContractGetComContractById(data) {
  return request('/enterprise/com-contract/get-com-contract-by-id', {
    method: 'POST',
    data
  });
}

/**
 * 合同管理-合同初始化
 * @author CXL
 */
export function enterpriseComContractInitComContract(data) {
  return request('/enterprise/com-contract/init-com-contract', {
    method: 'POST',
    data
  });
}

/**
 * 合同管理-新增合同
 * @author CXL
 */
export function enterpriseComContractInsertComContract(data, notip = false) {
  return request('/enterprise/com-contract/insert-com-contract', {
    method: 'POST',
    data
  }, false, notip);
}

/**
 * 合同管理-修改合同
 * @author CXL
 */
export function enterpriseComContractUpdateComContract(data) {
  return request('/enterprise/com-contract/update-com-contract', {
    method: 'POST',
    data
  });
}

/**
 * 保安人员列表查询
 * @author Lyq
 */
export function pageForPerInfo(data) {
  return request('/per-base-info/page-for-per-info', {
    method: 'POST',
    data
  });
}
/**
 * 保安证书列表查询
 * @author Lyq
 */
export function pageForPerCerInfo(data) {
  return request('/per-cer-baseinfo/page-for-per-cer-info', {
    method: 'POST',
    data
  });
}
//获取人员认证记录
export function getPerAuthRecord(data) {
  return request('/per-base-info/get-per-auth-record', {
    method: 'POST',
    data
  });
}
//未签订合同人员分页查询
export function pageNoSignContractPer(data) {
  return request('/enterprise/com-contract/page-no-sign-contract-per', {
    method: 'POST',
    data
  });
}
//通过合同ID查找驻勤点列表
export function getTaskListByContractId(data) {
  return request('/task/get-task-list-by-contractId', {
    method: 'POST',
    data
  });
}

/**********************************************企业注册******************************************/

/**
 * 选择人员
 * @author hjj
 */
export function getTreeperBydepart(data) {
  return request('/depart/get-treeper-bydepart', {
    method: 'POST',
    data: data || {}
  });
}
/**
 * 选择人员
 * @author Lyq
 */
export function getPerBaseInfoListByPerids(data) {
  return request('/person/get-per-base-info-list-by-perids', {
    method: 'POST',
    data: data || {}
  });
}
/** 企业人员信息列表 */
export function getTreeperBydepartMap(data) {
  return request('/depart/get-treeper-bydepart-map', {
    method: 'POST',
    data: data || {}
  });
}
/**获取公司的组织架构数（含数据权限）新*/
export function systemComDepartGetDepartTree(data) {
  return request('/depart/get-depart-tree', {
    method: 'POST',
    data: data || {}
  });
}
/**获取组织机构右边的人员列表（新）*/
export function systemComDepartGetOrgPersonList(data) {
  return request('/depart/get-org-person-list', {
    method: 'POST',
    data: data || {}
  });
}
/**获取部门app通讯录权限设置信息*/
export function getDepartAppAuthInfo(data) {
  return request('/depart/get-depart-app-auth-info', {
    method: 'POST',
    data: data || {}
  });
}
/**保存部门app通讯录权限设置信息*/
export function saveDepartAppAuthInfo(data) {
  return request('/depart/save-depart-app-auth-info', {
    method: 'POST',
    data: data || {}
  });
}
/**web通过姓名/手机号码/身份证搜索人员信息*/
export function systemComDepartGetWebPerListByKeyword(data) {
  return request('/depart/get-web-per-list-by-keyword', {
    method: 'POST',
    data: data || {}
  });
}

/**导出人员证书模板*/
export function perCerBaseinfoExportPerCerTemp(data) {
  return request('/per-cer-baseinfo/export-per-cer-temp', {
    method: 'POST',
    data: data || {}
  });
}
/**导入人员证书*/
export function perCerBaseinfoImportExcelPerCer(data) {
  return request('/per-cer-baseinfo/import-excel-per-cer', {
    method: 'POST',
    data: data || {}
  });
}
/*************保安员资格证申报****************/
/**查询未提交申报信息列表*/
export function getNoCommitBayzgzSbList(data) {
  return request('/public/bayzgz-sb/get-no-commit-bayzgz-sb-list', {
    method: 'POST',
    data: data || {}
  });
}
export function getNoApplyBayzgzList(data) {
  return request('/public/bayzgz-sb/get-no-apply-bayzgz-list', {
    method: 'POST',
    data: data || {}
  });
}
// 获取未持保安员资格证人员列表
export function pageNoBayzgzPerList(data) {
  return request('/per-cer-baseinfo/page-no-bayzgz-per-list', {
    method: 'POST',
    data: data || {}
  });
}
/**查询提交已百保盾申报信息列表*/
export function getCommitBayzgzSbList(data) {
  return request('/public/bayzgz-sb/get-committed-bayzgz-sb-list', {
    method: 'POST',
    data: data || {}
  });
}
/**获取人员的基础信息*/
export function getBayBaseInfo(data) {
  return request('/html/per-info/get-bay-base-info', {
    method: 'POST',
    data: data || {}
  });
}
/**获取人员合同列表2019*/
export function getComContractListByPerId(data) {
  return request('/enterprise/com-contract/get-com-contract-list-by-perId', {
    method: 'POST',
    data: data || {}
  });
}
/**校验企业是否配置了监管机构*/
export function checkIsSetRegulator(data) {
  return request('/enterprise/company/com-regulator-set/check-is-set-regulator', {
    method: 'POST',
    data: data || {}
  });
}
/**公共选人的接口(关键字查询)*/
export function getPerListByKeyword(data) {
  return request('/depart/get-common-per-list-by-keyword', {
    method: 'POST',
    data: data || {}
  });
}

/*****************************企业信息--企业监管****** */
/**获取公司所在省份公安机构列表*/
export function getSysPoliceList(data) {
  return request('/enterprise/company/com-regulator-set/get-sys-police-list', {
    method: 'POST',
    data: data || {}
  });
}
// 获取身份认证结果信息
export function getPerAuthRecordbyId(data = {}) {
  return request('/per-base-info/get-per-auth-record-by-id', {
    method: 'POST',
    data: data || {}
  });
}
/**********************************************公共接口******************************************/
/**获取选人公共部门树的人员列表*/
export function getDepartPersonList(data) {
  return request('/depart/get-depart-person-list', {
    method: 'POST',
    data: data || {}
  });
}
/**通过部门id获取助勤人员人员列表*/
export function getTaskDepartPersonList(data) {
  return request('/depart/get-task-depart-person-list', {
    method: 'POST',
    data: data || {}
  });
}
/**关键字查询助勤人员人员列表*/
export function getTaskPerListByKeyword(data) {
  return request('/depart/get-task-per-list-by-keyword', {
    method: 'POST',
    data: data || {}
  });
}

/**********************************************分公司管理******************************************/

export const {
  enterpriseCompanyComBaseInfoGetComBaseInfoById,
} = api_brachCompany;

/**********************************************任务管理******************************************/

export const {
  taskGetStepTwoDetail,
  // taskGetServerTypeList,
  taskGetIndustriesList,
  // taskDeleteTaskById,
  taskDeleteTask,
  // taskDoneTask,
  // taskCancelTask,
  taskManagementList,
  taskGetStepOneDetail,
  // taskTreeTaskType,
  taskSaveStepOneDetail,
  taskSaveStepTwoDetail,
  taskSaveStepThreeDetail,
  taskGetStepThreeDetail,
  taskGetThreePer,
  taskDeleteAddress,
  taskDeleteSchedulCycle,
  taskGetTaskById,
  getTaskGetTaskUnInsPerInfoList,
  taskGetTaskConflictPerInfoList,
  taskComTaskPerShiftValidateScheduleCycle,
  getTaskPerRecord,
  extentTask,
  endTask,
  pagePerTaskInfo,
  getNoSchedulShiftList,
  deleteTaskShift
} = api_taskbuild;



/**********************************************登录注册相关******************************************/

export const {
  systemPerAccountInfoVerificationPhone,
  systemPlatNewsSendVerificationCode,
  systemPerAccountInfoSave,
  accesstoken,
  getPublicKey,
  systemPlatNewsVerificationCode
} = apiLoginRegister;

/**********************************************华为会议******************************************/

export const {
  getComHuaweiMeet,
  getHuaweiAccesstoken,
  addUser,
  getHuaweiManageResource,
  setRegulatorMeetCharge,
  cancelRegulatorMeetCharge,
  pageForHuaweiMeetPerInfo,
  batchDeleteUser,
  getHuaweiPerListByKeyword,
  getHuaweiDepartPersonList,
  sendHuaweiMeetSms,
  buildHuaweiMeet,
  getHuaweiUserDetail,
  getProductList,
  checkProductCoupon,
  saveOrder,
  sendPayVerifycode,
  checkOrder,
  getOrderList,
  getPayPhone,
  getTranscribeFileList,
  batchDeleteTranscribeFile,
  getHuaweiCloudMeetRoomList,
  updateHuaweiCloudMemberVmr,
  assignToMember,
  recycleFromMember,
  getHuaweiCloudMemberVmrList,
  getHuaweiMeetList,
  getHuaweiMeetDetail
} = apiMeeting

/**********************************************金融钱包模块******************************************/
export const {
  getComWalletServiceOpenInfo,
  getComWalletServiceOpenInfoFormOne,
  saveBankCardChangeEvent,
  getComWalletCurrentProcess,
  getNoOpenWalletServicePerList,
  getOpenWalletServicePerList,
  getPerOpenWalletServiceInfo,
  getConfigBankList,
  sendVerifyCode,
  saveCccountInfo,
  getComWalletAccount,
  getComWalletAccountTradeDetail,
  getComWalletAccountAmount,
  getComWalletReconciliation,
  comWalletAccountExtract,
  getAccountConfirmApi,
  getWalletRechargeToken,
}
= apiWallet

//企业通讯录
export const {
  // enterpriseRoleUpdate,
  // enterpriseRoleSave,
  // enterpriseRoleGet,
  // enterpriseRoleDeleteById,
  // searchRoleGroup,
  // systemComRoleInsertPerRole,
  // searchRoleAndRoleGroupList,
  // searchPerSonByRoleId,
  // enterpriseRoleGroupSave,
  // enterpriseRoleGroupDelete,
  // searchRoleListBykeyword,
  // batchesDelete,
  // systemComDepartList,
  // systemPerCerBaseInfoFindAll,
  // systemConfigPerCerInfoFindListByPercertype,
  // systemPerCerBaseInfoSave,
  // systemComDepartPage,
  // systemComDepartPageTreeType,
  // systemComDepartUpdate,
  // systemComDepartGet,
  // systemPerCerBaseInfoDelete,
  // systemPerCerBaseInfoFind,
  // systemPerCerBaseInfoUpdate,
  // // systemPerBaseInfoGetInfoByPhone,
  // systemPlatNewsSendActivationMessage,
  // systemComDepartUpdateLeaveDate,
  // enterpriseLeaveList,
  // systemPerCerBaseInfoGet,
  // searchOnlyGroup,
  // systemComDepartAdjustDepart,
  // systemPerBaseInfoUpdateBaseInfo,
  // systemPerBaseInfoSaveBaseInfo,
  // systemPerBaseInfoGetPerBaseInfo,
  // systemConfigPerIndustryFindListByComId,
  // systemPerBaseInfoUpdateDetailedInfo,
  // systemComDepartExportDepart,
  systemComDepartGetTreeDepart,
  // systemComRoleFindAllRole,
  // enterpriseRoleGroupUpdate,
  // systemPerBaseInfoUpdateMobile,
  // deletePerColorPhotoUrl,
  // updatePerColorPhotoUrl
} = apiBusinessAddressBook;


//通过条件查询企业人员位置列表
export function getComPerLocationByKeyword(data) {
  return request('/system/prevent-command/get-com-per-location-by-keyword', {
    method: 'POST',
    data: data || {}
  });
}
export const {
  getTencentImSig,
  sendVideoRoomMsg,
  continueSendVideoRoomMsg,
  trtcVideoRoom,
  getTencentYspSig,
  getComTaskList,
  getComTempTaskList,
  getComTaskStationType,
  findComVideoRoomPage,
  getVideoRoomDetail,
  updateRoomEndTime,
  usersMyprofile,
  getPersonList,
  getTaskList,
  searchDeptUser,
  getUserAllInfo,
  getClassification,
  attendanceGetTypeData,
  perceptionGetTypeData,
  recentAbnormalData,
  getSecurityResourcesList,
  getTodayAbnormalData,
  getAbnormaCount,
  getTimeAbnormalCount,
  getEnterpriseList,
  passEnterpriseIDGetDepartList,
  passDepartIdGetDepartList,
  passDepartIdGetPersonList,
  passEnterpriseIDGetAttendanceList,
  passAttendanceIdGetPersonList,
  getTerminalByUserId,
  trackTrsearch,
  getLayoutAuthority,
  getGISMenu,
  getHaiKangApiUrl,
  getSearchInformation,
  getRangeData,
  getPoliceSearchInformation,
  getSecurityCompanyList,
  getDomainInfo,
  getRootDep,
  getSubdepartmentList,
  getAttendance,
  getDomainList,
  getSecurityManByAttendanceId,
  getEventByLevel,
  getEventByLevelList,
  updateEventStatus,
  getSecuritymanByDomainid
} = apiCommand
//获取企业人员位置分页列表
export function getComPerLocationPageList(data) {
  return request('/system/prevent-command/get-com-per-location-page-list', {
    method: 'POST',
    data: data || {}
  });
}


/**********************************************企业保险模块******************************************/
export const {
  enterpriseInsComInsPromptInitEnterpriseIns,
  comInsGetComInsPage,
  comInsUpdateComInsRemark,
  getOnlineInsBlbReportPageLink,
  enterpriseInsComInsGetInsBootPage,
  enterpriseInsComInsGetOnlineInsBlbPreservationLink,
  getOnlineInsBlbLink,
  getCompnayAndPersonPutCacheLink,
  getOnlineInsBlbDetailLink,
  findOfflineOrOnlinePolicy,
  addPreservationService,
  tempBatchInsPerToAddPreservationService,
  tempBatchInsPerToRelevance,
  getCompnayAndTempBatchInsPerPutCache,
  addBatchRelevancePer,
  findNotIncludedInsurancePerList,
  saveInsBlbMinusPreservationByNotIncluded,
  findUnderWarrantyPerListCount,
  saveInsBlbMinusPreservationService,
  findYIncumbencyPerCount,
  minusBatchRelevancePer,
  findUnderWarrantyPerList,
  comInsDeleteComInsUnderline,
  comInsGetComInsDetail,
  comInsInsertComInsUnderline,
  enterpriseInsComInsGetOnlineInsPerList,
  getOnlineInsBlbOrderPageLink,
  selectPrincipalByComId,
  insertBatchPrincipal,
  delBatchPrincipal,
  findUninsuredPerList,
  enterpriseInsComInsGetOnlineInsBlbPreservationPageLink,
  getInsProjects,
  recognizeInsurancePolicy,
  getLianbaoProList
} = apiInsurance