import { Modal, Form, DatePicker, message } from "antd";
import { taskDeleteTask, extentTask, endTask } from "../../../services/api";
// import $nModal from "../../../utils/modal/nModal";
// import locale from "antd/es/date-picker/locale/zh_CN";
// import moment from "moment";
export default function () {
  return [
    {
      title: '考勤组名称',
      dataIndex: 'taskName',
      key: 'taskName',
    },
    {
      title: '说明',
      dataIndex: 'taskContent',
      key: 'taskContent',
      render:(text)=>{
        return text||'-'
      }
    },
    {
      title: "状态",
      dataIndex: "taskEffect",
      key: "taskEffect",
      render: (text, record) => {
        return (
          <span
            style={{
              color:
                text === "生效"
                  ? "#008000"
                  : text === "未生效"
                  ? "#efa90d"
                  : "#da1010",
            }}
          >
            {text}
          </span>
        );
      },
    },
    
    {
      title: "考勤组时间",
      dataIndex: "startDate",
      key: "startDate",
      render: (text, record) => `${record.startDate}~${record.endDate}`,
    },
    {
      title: "考勤点",
      dataIndex: "kqds",
      key: "kqds",
      width: 100,
      fixed: "right",
      render: (text, record) => {
        if (record.taskStatusValue != 6) {
          return (
            <a
              href="#!"
              onClick={() => {
                // 0：暂存任务，1：正式任
                if (record.isFormal == "0") {
                  Modal.warning({
                    title: "这是一个暂存任务",
                  });
                } else {
                  this._showModal(
                    record.comTaskId,
                    "2",
                    record.taskName,
                    record.taskStatusValue
                  );
                }
              }}
            >
              {text}个
            </a>
          );
        } else {
          if (text == "0") {
            return <span>-</span>;
          } else {
            return <span>{text}个</span>;
          }
        }
      },
    },
    {
      title: "考勤人数",
      dataIndex: "zqrs",
      key: "zqrs",
      width: 100,
      fixed: "right",
      render: (text, record) => {
        if (record.taskStatusValue != 6) {
          return (
            <a
              href="#!"
              onClick={() => {
                this._showModal(
                  record.comTaskId,
                  "0",
                  record.taskName,
                  record.taskStatusValue
                );
              }}
            >
              {text}人
            </a>
          );
        } else {
          if (text == "0") {
            return <span>-</span>;
          } else {
            return <span>{text}人</span>;
          }
        }
      },
    },
    {
      title: "操作",
      dataIndex: "operation",
      key: "operation",
      width: 200,
      fixed: "right",
      render: (text, record) => {
        return (
          <div>
            {/* {
              // 未发布
              record.taskStatusValue == 6 && (
                <a
                  href="#!"
                  style={{ marginRight: 15 }}
                  onClick={() => {
                    this.props.history.push(
                      `/taskmanager/tasklist/newtask?id=${record.comTaskId.toString()}&model=detail`
                    );
                    // this.props.history.push(`/taskmanager/tasklist/taskDetail?id=${record.comTaskId}`);
                  }}
                >
                  继续完善
                </a>
              )
            } */}
            {record.taskStatusValue != 6 && record.zqrs>0 && (
              <a
                href="#!"
                style={{ marginRight: 15 }}
                onClick={() => {
                  this._showModal(
                    record.comTaskId,
                    "3",
                    record.taskName,
                    record.taskStatusValue,
                    {
                      startDate: record.startDate,
                      endDate: record.endDate,
                    }
                  );
                }}
              >
                排班
              </a>
            )}
            {record.taskStatusValue != 6 && (
              <a
                href="#!"
                style={{ marginRight: 15 }}
                onClick={() => {
                  // this.props.history.push(`/taskmanager/tasklist/taskDetail?id=${record.comTaskId}`);
                  this._showModal(record.comTaskId, "4", record.taskName);
                }}
              >
                编辑
              </a>
            )}
            {
              //只有未生效的任务才有删除按钮
              // record.taskEffect == "未生效" && (
                <a
                  href="#!"
                  style={{ marginRight: 15, color: "red" }}
                  onClick={() => {
                    Modal.confirm({
                      title: "即将删除考勤组，是否继续？",
                      content: (
                        <span style={{ color: "red" }}>
                          考勤组删除后，将同步解除考勤人员安排、删除今日的未完成的打卡记录（历史记录会保留）。
                        </span>
                      ),
                      okText: "确认",
                      cancelText: "取消",
                      onOk: () => {
                        taskDeleteTask({ comTaskId: record.comTaskId }).then(
                          (res) => {
                            if (res.retType === "0") {
                              Modal.success({
                                title: "考勤组删除成功!",
                                okText: "确定",
                                onOk: () => {
                                  this._updateTable();
                                },
                              });
                            }
                          }
                        );
                      },
                    });
                  }}
                >
                  删除
                </a>
              // )
            }
            {/* {
              //只有生效与终止的任务才有延期按钮
              (record.taskStatusValue === "1" ||
                record.taskStatusValue === "7") && (
                <a
                  href="#!"
                  style={{ marginRight: 15 }}
                  onClick={() => {
                    let date = record.endDate; //新结束日期选择
                    const lateEndDate =
                      new Date(Date.parse(record.endDate)) > new Date()
                        ? record.endDate
                        : moment(new Date()).format("YYYY-MM-DD");
                    $nModal({
                      width: 650,
                      title: "驻勤点延期",
                      content: (
                        <div>
                          <p style={{ color: "orange" }}>
                            若为已终止的驻勤点延期，则请重新安排人员及排班；若只是对生效的驻勤点进行延期，则只更新结束时间。
                          </p>
                          <label
                            style={{
                              display: "inline-block",
                              marginRight: "16px",
                            }}
                          >
                            新结束日期：
                            <DatePicker
                              defaultValue={moment(date, "YYYY-MM-DD")}
                              format="YYYY-MM-DD"
                              placeholder="请选择日期"
                              onChange={(e) => {
                                date = e ? e.format("YYYY-MM-DD") : "";
                              }}
                              locale={locale}
                              disabledDate={(current) => {
                                return (
                                  current &&
                                  current < moment(lateEndDate, "YYYY-MM-DD")
                                );
                              }}
                            />
                          </label>
                        </div>
                      ),
                      onOk: (close) => {
                        if (!date) {
                          return message.warning("请先选择时间");
                        } else if(new Date(Date.parse(moment(date).format("YYYY-MM-DD")))<new Date(Date.parse(moment(new Date()).format("YYYY-MM-DD"))) ){
                          return message.warning("请更换结束日期")
                        } else {
                          extentTask({
                            comTaskId: record.comTaskId,
                            endDate: date,
                          }).then((res) => {
                            if (res.retType === "0") {
                              Modal.success({
                                title: "延期成功!",
                                okText: "确定",
                                onOk: () => {
                                  this._updateTable();
                                  close();
                                  date = "";
                                },
                              });
                            }
                          });
                        }
                      },
                    });
                  }}
                >
                  延期
                </a>
              )
            } */}
            {/* {
              //只有生效状态才有终止按钮
              record.taskStatusValue == "1" && (
                <a
                  href="#!"
                  style={{ marginRight: 15, color: "orange" }}
                  onClick={() => {
                    Modal.confirm({
                      title: "即将终止驻勤点，是否继续？",
                      content: (
                        <span style={{ color: "red" }}>
                          驻勤点操作终止后，将更新驻勤点结束日期为今日（即今日为该驻勤点的最后一天，今日仍需进行排班执勤）。次日时系统将更新驻勤点状态为终止，驻勤人员将被清空。
                        </span>
                      ),
                      okText: "确认",
                      cancelText: "取消",
                      onOk: () => {
                        endTask({ comTaskId: record.comTaskId }).then((res) => {
                          if (res.retType === "0") {
                            Modal.success({
                              title: "终止成功!",
                              okText: "确定",
                              onOk: () => {
                                this._updateTable();
                              },
                            });
                          }
                        });
                      },
                    });
                  }}
                >
                  终止
                </a>
              )
            } */}
          </div>
        );
      },
    },
  ];
}
