import React, { Component } from "react";
import {
  Button,
  Form,
  Input,
  Cascader,
  Select
} from "antd";
import {
  // taskTreeTaskType
} from '../../../services/api';
const { Option } = Select;
@Form.create()
export default class Messages extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
    };
  }
  componentDidMount() {
    // this.__taskTreeTaskType();
    this.props.onSearch(this.props.form.getFieldsValue());
  }
  _search = (e) => {
    e.preventDefault();
    this.props.form.validateFields((err, values) => {
      // 搜索的时候重置为第一页
      values.pageNumber = 1;
      this.props.onSearch(values);
    });
  }
  _reset = () => {
    this.props.form.resetFields();
    const data = this.props.form.getFieldsValue();
    this.props.onSearch(data);
  }
  render() {
    const { getFieldDecorator } = this.props.form;
    return (
      <Form layout="inline" onSubmit={this._search}>
        <Form.Item label="考勤组名称">
          {getFieldDecorator('taskName', {
            initialValue: ''
          })(
            <Input placeholder="请输入" />
          )}
        </Form.Item>

        <Form.Item label="考勤组状态"> 
          {getFieldDecorator('taskEffect',{
            initialValue: ''
          })(
            <Select style={{minWidth: 200}} >
              <Option value="">全部</Option>
              <Option value="0">未生效</Option>
              <Option value="1">生效</Option>
              <Option value="2">终止</Option>
            </Select>
          )}
        </Form.Item>
        <Form.Item label=" " colon={false}>
          <Button type="primary" onClick={this._search}>搜索</Button>
        </Form.Item>
        <Form.Item label=" " colon={false}>
          <Button onClick={this._reset}>重置</Button>
        </Form.Item>

      </Form>
    );
  }
}
