import React, { Component } from 'react';

import {
  Tabs,
  Radio,
  DatePicker,
  Popconfirm,
  message 
} from "antd";
import moment from 'moment';

import LetterElment from '../../../components/LetterElment';

import {
  taskComTaskPerShiftValidateSinglePerShift
} from '../../../services/api';

const { TabPane } = Tabs;
export default class PopconfirmContent extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      activeKey: '1', //tab值
      shiftsValue: this.props.shiftsValue, //单个排班的id
      taskSchedulCycleId: '',  //周期排班的id
      endDate: this.props.shiftDate.endDate
    }
  }


  componentWillReceiveProps(props) {

  }

  componentDidMount() {

  }

  render() {
    return (
      <Popconfirm
        title={
          <Tabs className="popover-paibang" activeKey={this.state.activeKey} onChange={activeKey => {
            this.setState({
              activeKey
            });
          }}>
            <TabPane tab="排班" key="1">
              <Radio.Group
                onChange={e => {
                  this.setState({
                    shiftsValue: e.target.value
                  });
                }}
                value={this.state.shiftsValue}
              >
                {
                  this.props.addedShifts.map((v, k) => {
                    return (
                      <Radio key={k} value={v.shiftId}>
                        <LetterElment
                          name={this.props.shiftAliasAlphaMap[v.shiftId]}
                          type="tag"
                        />
                        <span style={{ whiteSpace: 'pre-wrap' }}>{v.shiftAlias}</span>
                      </Radio>
                    );
                  })
                }
              </Radio.Group>
            </TabPane>

            {/* <TabPane tab='周期排班' key='2'>
              <Radio.Group
                onChange={e => {
                  this.setState({
                    taskSchedulCycleId: e.target.value
                  });
                }}
                value={this.state.taskSchedulCycleId}
              >
                {
                  this.props.cycleList.map((v, k) => {
                    return (
                      <Radio key={k} value={v.taskSchedulCycleId}>
                        <span style={{ whiteSpace: 'pre-wrap' }}>{v.cycleAlias}</span>
                      </Radio>
                    );
                  })
                }
              </Radio.Group>
              <div style={{ marginTop: '20px' }}>
                <span>循环截止日期:</span>
                <div style={{ marginTop: '10px' }}>
                  <DatePicker
                    placeholder='请选择循环截止日期'
                    allowClear={false}
                    value={
                      moment(this.state.endDate, 'YYYY-MM-DD')
                    }
                    onChange={date => {
                      const endDate = moment(date).format('YYYY-MM-DD');
                      this.setState({
                        endDate
                      });
                    }}
                  />
                </div>
              </div>
            </TabPane> */}
          </Tabs>
        }
        trigger="click"
        okText="确定"
        cancelText="取消"
        // onVisibleChange={visible => {
        //   this.setState({
        //     [visibleKey]: visible
        //   });
        // }}
        onConfirm={() => {
          const { comTaskId, perId, date} = this.props.params;
          const ajaxData = {
            comTaskId,
            perId,
            date,
            taskShiftType: this.state.activeKey,
            ids: this.state.shiftsValue
          }
          const fetchData = (data) => {
            taskComTaskPerShiftValidateSinglePerShift(data).then(res => {
              this.props.getTableData();
            });
          }
          if (ajaxData.taskShiftType == '1') {
            if (this.state.shiftsValue) {
              if (this.state.shiftsValue != this.props.shiftsValue) {
                fetchData(ajaxData);
              } else {
                message.warning('班次未修改！');
              }
            } else {
              message.warning('未选择班次！');
            }
          } else {
            if (this.state.taskSchedulCycleId) {
              const selectedEndDate = moment(this.state.endDate).valueOf();
              const endDate = this.props.shiftDate.endDate ? moment(this.props.shiftDate.endDate.replace(/-/g, '/')).valueOf() : '';
              const curTableDate = moment(date.replace(/-/g, '/')).valueOf();
              if (selectedEndDate > endDate) {
                return message.warn('选择不大于可排班日期！');
              }
              if(selectedEndDate < curTableDate) {
                return message.warn(`选择不小于${date}日!`);
              }
              ajaxData.taskShiftType = '2';
              ajaxData.ids = this.state.taskSchedulCycleId;
              ajaxData.endDate = this.state.endDate;
              fetchData(ajaxData);
            } else {
              message.warning('请选择周期排班！');
            }
          }
        }}
        onCancel={() => {

        }}
      // onClick={() => {

      // }}
      >
        <div
          className='paneltablecolor-list'
          onClick={() => {

          }}
        >
          {
            this.props.shiftsValue && this.props.shiftAliasAlphaMap[this.props.shiftsValue] &&
            <LetterElment
              name={this.props.shiftAliasAlphaMap[this.props.shiftsValue]}
              type='tag'
            />
          }
        </div>
      </Popconfirm>
    );
  }
}
