import React, { Component } from "react";
import RreactDom from "react-dom";
import { Modal, Alert, Input, Button, ConfigProvider } from "antd";
import style from "styled-components";
import zh_CN from 'antd/lib/locale-provider/zh_CN';
import ExcelButtonOline from "../../../../components/ExcelButtonOline";
import PTable from "../../../../components/Pro/PTable";
import moment from 'moment';
import 'moment/locale/zh-cn';
moment.locale('zh-cn');
// 弹窗组件
class PersonRecord extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      visible: true,
      forceUpdate: false,
      keyWord: '',
      pageParm: {
        keyWord: '',
        pageNumber: 1,
        pageSize: 10,
        comTaskId: props.comTaskId
      },
    };
  }
  updateForce() {
    this.setState({
      forceUpdate: true
    }, () => {
      this.setState({
        forceUpdate: false
      })
    })
  }
  render() {
    const close = () => {
      this.setState(
        {
          visible: false,
        },
        () => {
          // 删除组件
          const divs = document.getElementsByClassName("record_modal");
          Reflect.apply(Array.prototype.forEach, divs, [
            (item) => {
              RreactDom.unmountComponentAtNode(item);
              document.body.removeChild(item);
            },
          ]);
        }
      );
    };
    const columns = [
      {
        title: "序号",
        dataIndex: "number",
        key: "number",
      },
      {
        title: "姓名",
        dataIndex: "perName",
        key: "perName",
      },
      {
        title: "手机号码",
        dataIndex: "mobilePhone",
        key: "mobilePhone",
      },
      {
        title: "身份证号",
        dataIndex: "idCardNo",
        key: "idCardNo",
      },
      {
        title: "开始日期",
        dataIndex: "startDate",
        key: "startDate",
      },
      {
        title: "结束日期",
        dataIndex: "endDate",
        key: "endDate"
      },
    ];
    return (
      <div>
        <Modal
          title="人员安排记录"
          visible={this.state.visible}
          okText={this.props.okText || "确定"}
          cancelText={this.props.cancelText || "取消"}
          onOk={() => {
            close();
            // this.props.onOk && this.props.onOk(selectedList);
          }}
          onCancel={() => {
            close();
            // this.props.onCancel && this.props.onCancel(selectedList, close);
          }}
          width={700}
        >
          <div>
            <Alert
              message={
                <div>
                  <span>
                    以下人员为曾经安排到本驻勤点的人员信息。开始、结束时间为该人员安排到本驻勤点的时间段。
                  </span>
                </div>
              }
              type="warning"
              showIcon
              style={{ marginBottom: "15px" }}
            />
            <div>
              <label>
                关键字：
                <Input
                  style={{ width: 214, marginBottom: "10px" }}
                  placeholder="姓名/身份证/手机号"
                  onChange={(e) => {
                    this.setState({
                      keyWord: e.target.value.trim()
                    })
                  }}
                  value={this.state.keyWord}
                  maxLength={20}
                />
              </label>
              <Btns>
                <Button
                  style={{ width: 65, height: 31.5, borderRadius: 6 }}
                  onClick={() => {
                    const { keyWord } = this.state;
                    console.log(keyWord)
                    this.setState({
                      pageParm: {
                        ...this.state.pageParm,
                        keyWord
                      }
                    }, () => {
                      this.updateForce()
                    })
                  }}
                  type="primary"
                >
                  搜索
                </Button>
                <Button
                  style={{ width: 65, height: 31.5, borderRadius: 6 }}
                  onClick={() => {
                    this.setState({
                      pageParm: {
                        ...this.state.pageParm,
                        keyWord: ''
                      },
                      keyWord: ''
                    }, () => {
                      this.updateForce()
                    })
                  }}
                >
                  重置
                </Button>
                <ExcelButtonOline
                  params={this.state.pageParm}
                  apiurl={'/task/export-task-per-record'}
                  downloadname={"人员安排记录表格"}
                >
                  导出
                </ExcelButtonOline>
              </Btns>
              {/* 虽然在全局设置了中文，但是这里没有生效 */}
              <ConfigProvider locale={zh_CN}>
                <PTable
                  columns={columns}
                  url="getTaskPerRecord"
                  pageParm={this.state.pageParm}
                  forceUpdate={this.state.forceUpdate}
                  pagination={{ showTotal: total => `总共 ${total} 条` }}
                />
              </ConfigProvider>
            </div>
          </div>
        </Modal>
      </div>
    );
  }
}

// 插入弹窗
export default function showInsuranceModal(props) {
  const div = document.createElement("div");
  div.setAttribute("class", "record_modal");
  document.body.appendChild(div);
  RreactDom.render(<PersonRecord {...props} />, div);
}
const Btns = style.span`{
    margin: 10px 10px;
    >button{
      margin-right: 15px;
    }
  }`;
