import React, { Component } from 'react';

import { withRouter } from 'dva/router';

import {
  Modal,
  Table,
  message
} from "antd";

import PTable from '../../../components/Pro/PTable';

import {
  taskShiftAddTaskShift,
  taskShiftGetNoSetShiftList
} from '../../../services/api';


@withRouter
export default class SchedulingModal extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      visible: false,
      list: [], //过滤后的已有班次
      selectedRows: [],

      forceUpdate: false,
      pageParm: { //列表请求参数
        pageSize: '10',
        pageNumber: '1'
      },
    }
  }


  componentWillReceiveProps(props) {
    const { visible, existingShifts, addedShifts, comTaskId } = props;
    if(visible != this.state.visible) {
      this.setState({visible}, () => {
        if(visible) {
          // const list = existingShifts.filter(val => !addedShifts.some(item => item.shiftId == val.shiftId));
          // this.setState({ list, selectedRows: [] });
          this.setState({
            pageParm: {
              ...this.state.pageParm,
              comTaskId
            }
          });
        }
      });
    }
  }
  componentDidMount() {

  }


  render() {

    return (
      <Modal
        title="选择班次"
        className='drawer-box'
        visible={this.state.visible}
        width={600}
        destroyOnClose={true}
        maskClosable={false}
        onCancel={() => this.props.setState({existingShiftShow: false})}
        onOk={() => {
          const { addedShifts, comTaskId } = this.props;
          const { selectedRows } = this.state;
          const total = [ ...addedShifts, ...selectedRows ];
          if(total.length > 26) {
            return message.warning('最多只能选择26个班次！');
          }
          const shiftIdStr = selectedRows.map(({ shiftId }) => shiftId).join(',');
          taskShiftAddTaskShift({
            comTaskId,
            shiftIdStr
          }).then(res => {
            // 刷新&&关闭弹窗
            this.props.setState({existingShiftShow: false});
            this.props.updatePage();
          });
        }}
      >
        {
          this.state.pageParm.comTaskId &&
          <PTable
            pageParm={this.state.pageParm}
            // pagination={{
            //   defaultPageSize: 8,
            //   pageSizeOptions: ["8", "12", "16", "20", "25"],
            //   showSizeChanger: true
            // }}
            url="taskShiftGetNoSetShiftList"
            rowSelection={{
              // selectedRowKeys: this.state.selectedRowKeys,
              onChange: (selectedRowKeys, selectedRows) => {
                this.setState({selectedRows});
              }
            }}
            columns={[
              {
                title: '班次名称',
                dataIndex: 'shiftName',
                key: 'shiftName'
              },
              {
                title: '出勤时间',
                dataIndex: 'shiftRuleDetail',
                key: 'shiftRuleDetail',
                render: text => <div dangerouslySetInnerHTML={{ __html: text }} />
              }
            ]}
          />
        }
      </Modal>
    );
  }
}
