/**
 * 会议室列表
 */
import React, { Component } from "react";
import { connect } from "dva";
import { Table, Button, Input, Alert, Spin, Select, } from "antd";
import Detail from "./Detail";
// import Join from "./Join";
import tablePage from '../../../utils/hoc/tablePage';
import Create from "./Create";
import { withRouter } from "dva/router";
import "../meeting.less";
import { addUTC } from '../../../utils/utils';
const Option = Select.Option;
@connect(state => ({
  client: state.client.client,
  loginStatus: state.client.loginStatus,
  currentConferID: state.client.currentConferID,
  updateISRefreshMeetingList: state.client.updateISRefreshMeetingList
}))
@tablePage()
@withRouter
export default class MyMeeting extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      searchMeetingData: {
        //获取会议列表参数
        pageIndex: 1,
        pageSize: 10
      },
      forceUpdate: false, //刷新数据
      tableList: [], //会议列表数据
      visible: false, //抽屉详情状态
      clickConferenceID: null, //当前选中的会议id
      updateMeetListState: false,
      createVisible: false, //创建会议的模态框状态
      joinVisible: false //加入会议的模态框状态
    };
  }
  componentDidMount() {
    this.props.loginStatus && this.getMyMeetingList(1);
  }
  componentWillReceiveProps(nextProps) {
    // if (
    //   nextProps.loginStatus !== this.props.loginStatus &&
    //   nextProps.loginStatus
    // ) {
    //   this.getMyMeetingList(1);
    // }
    // if (nextProps.updateISRefreshMeetingList) {
    //   const _this = this;
    //   setTimeout(function() {
    //     _this.getMyMeetingList(1);
    //   }, 800);
    // }
  }
  //获取我的会议列表
  // getMyMeetingList(pageIndex, param) {
  //   if (!!this.props.client) {
  //     const _this = this;
  //     this.props.client.getMyConfList(
  //       pageIndex,
  //       this.state.searchMeetingData.pageSize,
  //       function(ret) {
  //         if (ret.result) {
  //           _this.setState({
  //             tableList: ret.info
  //           });
  //         }
  //         _this.props.dispatch({
  //           type: `client/setISRefreshMeetingList`,
  //           payload: {
  //             updateISRefreshMeetingList: false
  //           }
  //         });
  //       }
  //     );
  //   }
  // }
  //重新加入会议
  // joinMeeting(record) {
  //   var defaultPsw = "******";
  //   var confPsw = record.chairmanPasswd;
  //   if (confPsw == defaultPsw || confPsw == "") {
  //     confPsw = record.generalPasswd;
  //   }
  //   let joinConfParam = {
  //     conferenceId: record.conferenceID,
  //     accessNumber: record.accessNumber,
  //     confPasswd: confPsw
  //   };
  //   const _this = this;
  //   this.props.client.joinConference(joinConfParam, function(ret) {
  //     if (ret.result) {
  //       _this.props.dispatch({
  //         type: `client/setCurrentConferID`,
  //         payload: {
  //           currentConferID: record.conferenceID,
  //           currentConferTopic: record.topic
  //         }
  //       });
  //     }
  //   });
  // }
  searchPassward(data, param) {
    let text = '-'
    if (data.length > 0) {
      data.map(item => {
        if (item['conferenceRole'] == param) {
          text = item['password'] ? item['password'] : '-'
        }
      })
    }
    return text
  }
  // 表格渲染
  renderOrderList = () => {
    const columns = [
      {
        title: "会议主题",
        dataIndex: "subject",
        key: "subject"
      },
      {
        title: "会议开始时间",
        dataIndex: "startTime",
        key: "startTime",
        render: (text, record) => (
          <span>{addUTC(text, 'add')}</span>
        )
      },
      {
        title: "会议结束时间",
        dataIndex: "endTime",
        key: "endTime",
        render: (text, record) => (
          <span>{addUTC(text, 'add')}</span>
        )
      },
      {
        title: "会议ID",
        dataIndex: "conferenceID",
        key: "conferenceID"
      },
      {
        title: "来宾密码",
        dataIndex: "generalPasswd",
        key: "generalPasswd",
        render: (text, record) => (
          <span>
            {
              this.searchPassward(record.passwordEntry, 'general')
            }
          </span>
        )
      },
      {
        title: "主席密码",
        dataIndex: "chairmanPasswd",
        key: "chairmanPasswd",
        render: (text, record) => (
          <span>
            {
              this.searchPassward(record.passwordEntry, 'chair')
            }
          </span>
        )
      },
      {
        title: "会议类型",
        dataIndex: "mediaTypes",
        key: "mediaTypes",
        render: (text, record) => (
          <span>
            {text ? text.indexOf('Video') > -1 ? text.indexOf('HDVideo') > -1 ? '高清视频' : '标清视频' : '语音' : '其他类型'}
          </span>
        )
      },
      {
        title: "操作",
        key: "action",
        render: (text, record) => (
          <span>
            <span
              className="action-span"
              onClick={() => {
                this.setState({
                  visible: true,
                  clickConferenceID: record.conferenceID
                });
              }}
            >
              详情
            </span>
            {/* <span
              className="action-span"
              type="primary"
              onClick={() => {
                this.joinMeeting(record);
              }}
            >
              加入
            </span> */}
            {/* {this.props.currentConferID === record.conferenceID ? (
              <span
                className="action-span"
                onClick={() => {
                  this.props.history.push({
                    pathname: `/meeting/control`,
                    state: record
                  });
                }}
              >
                会议控制
              </span>
            ) : (
              ""
            )} */}
          </span>
        )
      }
    ];
    const { PageTable, isInit } = this.props;
    if (!isInit) return;
    return (
      <PageTable
        columns={columns}
        url="getHuaweiMeetList"
      // scroll={{ x: '2000px' }}
      />
    );
  };
  __renderConfiMode = () => {
    const mode = [{
      value: 'ADAY',
      label: '一天'
    }, {
      value: 'AWEEK',
      label: '一周'
    }, {
      value: 'AMONTH',
      label: '一个月'
    }, {
      value: '',
      label: '所有'
    }]
    return mode.map((val, key) => {
      return (
        <Option key={key} value={val.value}>
          {val.label}
        </Option>
      );
    });
  }

  render() {
    const { SearchForm, Form } = this.props;
    const { getFieldDecorator } = this.props.form;
    return (
      <div className="my-meeting">
        {/* <Spin tip="会议初始中，请稍等..." spinning={!this.props.loginStatus}> */}
        <div>
          <Alert
            message={
              <div style={{ color: "#333" }}>
                <div>
                  1、会议发起成功后，请下载并使用华为云会议客户端加入会议；点击下载华为云会议客户端：<a href="https://softclient.meeting.huaweicloud.com/HUAWEICLOUDMeeting_Win.exe">Windows版</a>  | <a href="https://softclient.meeting.huaweicloud.com/HUAWEICLOUDMEETING_Mac.dmg">MacOS版</a>
                </div>
                <div>
                  2、加入会议时，输入本页面显示的会议ID及密码即可加入；主席请使用主席密码，其他人员请使用来宾密码邀请加入；加入他人会议也请直接使用客户端加入即可。
                  </div>
              </div>
            }
            type="warning"
            showIcon
            style={{ marginBottom: "15px" }}
          />
          <Button
            type="primary"
            onClick={() => {
              this.setState({ createVisible: true });
            }}
          >
            发起会议
            </Button>
          {/* <Button
              type="primary"
              style={{ margin: "0 10px" }}
              onClick={() => {
                this.setState({
                  joinVisible: true
                });
              }}
            >
              加入会议
            </Button> */}
        </div>
        <div style={{ margin: "10px" }}>
          <SearchForm>
            <Form.Item label="关键字">
              {getFieldDecorator('keyWord', {
                initialValue: ''
              })(
                <Input style={{ width: 240 }} placeholder="请输入会议名称/预订人/ID" />
              )}
            </Form.Item>
            <Form.Item label="会议时间">
              {getFieldDecorator('queryConfMode', {
                initialValue: ''
              })(
                <Select style={{ width: 100 }}>
                  {
                    this.__renderConfiMode()
                  }
                </Select>
              )}
            </Form.Item>
          </SearchForm>
          {this.renderOrderList()}
          {/* <Table
              columns={columns}
              dataSource={this.state.tableList}
              rowKey={record => record.conferenceID}
              pagination={{
                total: 2,
                defaultPageSize: this.state.searchMeetingData.pageSize
                  ? parseInt(this.state.searchMeetingData.pageSize)
                  : 10,
                pageSizeOptions: ["5", "10", "15", "25", "50"],
                showSizeChanger: true,
                onChange: number => {
                  this.getMyMeetingList(number);
                },
                onShowSizeChange: (current, size) => {
                  this.setState(
                    {
                      searchMeetingData: {
                        ...this.state.searchMeetingData,
                        pageSize: size
                      }
                    },
                    () => this.getMyMeetingList(current)
                  );
                }
              }}
            /> */}
          <Detail
            onChange={visible => {
              this.setState({ visible });
            }}
            visible={this.state.visible}
            clickConferenceID={this.state.clickConferenceID}
          />
        </div>
        {/* <Join
            joinVisible={this.state.joinVisible}
            changeJoinStatus={visible => {
              this.setState({
                joinVisible: visible
              });
            }}
          /> */}
        {this.state.createVisible && (
          <Create
            createVisible={this.state.createVisible}
            changeCreateStatus={visible => {
              this.setState({
                createVisible: visible
              });
            }}
            updateTable={() => this.props.updateTable()}
          />
        )}
        {/* </Spin> */}
      </div>
    );
  }
}
