/**
 * 保险商城
 */
import React, { Component } from 'react';
import { Tabs, Alert } from 'antd';
const TabPane = Tabs.TabPane;
import * as ajax from '../../../services/api';
import { Link } from 'dva/router';
import { connect } from 'dva';
@connect(state => ({
  global: state.global
}))
export default class InsuranceDetails extends Component {
  constructor(props, context) {
    super(props, context);  
    this.state = {
      url: '' 
    };
  }
  componentDidMount() {
    // 获取商城链接
    const params = new URLSearchParams(this.props.location.search);
    const url = decodeURIComponent(params.get('url'));
    if(url != 'null') {
      this.setState({url});
    }else {
      this._messageOnline();
    }
  }
  //在线购买保险的链接生成
  _messageOnline = () => {
    ajax
      .getOnlineInsBlbLink({
        comId: this.props.global.companyInfo.comId
      })
      .then(data => {
        this.setState({
          url: data.data
        });
      });
  };
  
  render() {
    // console.log(this.props.location.state.url)
    return (
      <div>
        {/* <Tabs defaultActiveKey="1" style={{padding: '0 16px'}}>
          <TabPane tab="保险商城" key="1"> */}
            {this.state.url&&<iframe
              title="购买在线保险"
              src={this.state.url}
              style={{ height: 'calc(100vh)'}}
              width="100%"
              frameBorder="0"
              allowFullScreen={true}
              allowtransparency="true"
            >
              您的浏览器不支持iframe，请升级
            </iframe>}
          {/* </TabPane>
        </Tabs>   */}
      </div> 
    );
  }
}
