import React, { Component } from 'react';
import { connect } from 'dva';
import {
  Input,
  Button,
  Table,
  Select,
  Modal,
  message,
  Radio,
  Alert,
  TreeSelect,
  DatePicker,
  Icon,
  notification,
  Popover
} from 'antd';
import moment from 'moment';
import BulkInsuranceModal from './BulkInsuranceModal';
const RadioGroup = Radio.Group;
import "moment/locale/zh-cn";
import { withRouter } from 'dva/router';
import '../less/insurance.less';
import { gup, log, $log } from '../../../../../utils/utils';
// import * as ajax from '../../../../../services/api';
import * as ajax from '../../../../../services/api';
import 
// ExcelButtonOline, 
{ excelButtonHOC } from '../../../../../components/ExcelButtonOline';
const { Option } = Select;
@connect(state => ({
  global: state.global
}))
@withRouter
export default class Uninsured extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      // 搜索部分
      searchData: {  // 表格数据请求参数
        perType: '',  //人员类型
        keyword: '',  //关键字
        departId: '',  //部门id
        pageNumber: '1',  // 页	
        pageSize: '10',  //条目
        businessType: this.props.insuranceType === 'temporary' ? 1 : 0,  // 1-临保保险 0-团体保险
        comName: '', // 所属企业
        tlkProjectId: this.props.tlkProjectId || undefined, // 使用父组件传递的项目id
      },
      keyword: '', //关键字
      perType: '',  //人员类型
      departId: '', //部门id

      canExport: false, //是否可以导出表格
      treeData: [  // 部门数据
        //树
        { title: '', key: '' }
      ],
      perTypeList: [], // 人员类别
      // 移除proList状态，使用父组件传递的props
      // 表格部分
      tableList: [], // 表格数据
      loading: false,  //表格数据加载动画
      pagination: {  //分页数据
        total: 1,
        current: 1,
        pageSize: 10,
        showSizeChanger: true,
        showQuickJumper: true,
        pageSizeOptions: ['10', '50', '100', '500'],
        onShowSizeChange: (current, pageSize) => {
          // this.setState({
          //   searchData: {
          //     ...this.state.searchData,
          //     pageSize: pageSize+'',
          //     pageNumber: current+''
          //   }
          // },() => {
          //   console.log(this.state.searchData);
          //   this.getTable(this.state.searchData);
          // });
          // console.log(current, pageSize);
        }
      },
      // totalNums: 0, //所有数量
      selectedRows: [], //表格中选中的数组
      recoverRows: [],  //表格中选中的数组 （备份）
      selectedRowKeys: [],
      // 弹窗部分
      // 弹窗1
      modalVisible: false, // 批量购买保险模态框显示状态
      radio: '0', // 单选框的值 

      // 弹窗2 关联线上保单
      onlineVisible: false, //关联线上保单模态框
      onlineOrderId: '',
      // 下拉框的数据
      onlineList: [],

      // 弹窗3 关联线下保单
      outlineVisible: false,  //关联线下保单模态框
      outlineList: [],  //下拉框
      outlineIndex: 0,   //下拉框序号
      alreadyLinkedNum: 0, //已经关联的人数

      //线下成功弹窗
      outlineSuccessModal: false,
      outlineSuccessTitle: '',

      // 导入投保
      bulkVisible: false,  //导入投保人员是显示
      importBatchId: '',  //批次id
      importCount: 0,  //导入投保成功的人数
      // isImport: false,  //判断当前是导入投保还是选择表格中的人员进行投保
      isLinbao: this.props.insuranceType === 'temporary' ? true : false,  //判断是否是临保
    };
  }


  // 缓存数据，避免重复请求
  static cachedData = {
    departments: null,
    perTypes: null,
    projects: null,
    onlinePolicy: null,
    offlinePolicy: null,
    lastUpdateTime: null
  };

  componentWillReceiveProps(props) {
    // 只有当updateNum变化且大于0时才重新获取表格数据
    if (props.updateNum && props.updateNum > 0 && props.updateNum !== this.props.updateNum) {
      this.getTable(this.state.searchData);
    }
  }
  
  componentDidMount() {
    this.initPage();
  }
  
  componentDidUpdate(prevProps) {
    // 当项目ID变化时，更新表格数据
    if (prevProps.tlkProjectId !== this.props.tlkProjectId) {
      const searchData = {
        ...this.state.searchData,
        tlkProjectId: this.props.tlkProjectId || '*****'
      };
      this.setState({ searchData }, () => {
        this.getTable(searchData);
      });
    }
  }

  // 初始化
  initPage = () => {
    // 检查缓存是否过期（设置缓存有效期为10分钟）
    const now = new Date().getTime();
    const cacheExpired = !Uninsured.cachedData.lastUpdateTime || 
                         (now - Uninsured.cachedData.lastUpdateTime > 10 * 60 * 1000);
    
    // 如果缓存过期，更新缓存时间戳
    if (cacheExpired) {
      Uninsured.cachedData.lastUpdateTime = now;
    }

    // 根据保险类型初始化不同数据
    if (this.state.isLinbao) {
      // 不再需要获取项目列表，直接获取表格数据
      this.getTable(this.state.searchData);
    } else {
      // 获取部门和人员类型（使用缓存或重新请求）
      this.getDepart(cacheExpired, () => {
        this.getPerType(cacheExpired, () => {
          this.getTable(this.state.searchData);
        });
      });
    }
   
    // 获取保单数据（使用缓存或重新请求）
    // this.getPolicyData(cacheExpired);
  }

  // 获取线上保单
  getOnlinePolicyData = (forceUpdate = false) => {
    if (forceUpdate || !Uninsured.cachedData.onlinePolicy) {
      ajax.findOfflineOrOnlinePolicy({ 
        buyMode: 1,
        businessType: this.props.insuranceType === 'temporary' ? 1 : 0,
        tlkProjectId: this.props.tlkProjectId || undefined
       }).then(res => {
        const onlineOrderId = res.data[0] ? res.data[0].orderId : '';
        Uninsured.cachedData.onlinePolicy = res.data;
        this.setState({
          onlineList: res.data,
          onlineOrderId
        });
      });
    } else {
      // 使用缓存数据
      const onlineOrderId = Uninsured.cachedData.onlinePolicy[0] ? 
                           Uninsured.cachedData.onlinePolicy[0].orderId : '';
      this.setState({
        onlineList: Uninsured.cachedData.onlinePolicy,
        onlineOrderId
      });
    }
  }
  // 获取线下保单
  getOutlinePolicyData = (forceUpdate = false) => {
    if (forceUpdate || !Uninsured.cachedData.offlinePolicy) {
      ajax.findOfflineOrOnlinePolicy({ 
        buyMode: 2,
        businessType: this.props.insuranceType === 'temporary' ? 1 : 0,
        tlkProjectId: this.props.tlkProjectId || undefined
       }).then(res => {
        const filteredData = res.data.filter(item => item.perNum > 0);
        Uninsured.cachedData.offlinePolicy = filteredData;
        this.setState({
          outlineList: filteredData
        }, () => {
          if (this.state.outlineList.length > 0) {
            this._getAlreadyLinkedNum();
          }
        });
      });
    } else {
      // 使用缓存数据
      this.setState({
        outlineList: Uninsured.cachedData.offlinePolicy
      }, () => {
        if (this.state.outlineList.length > 0) {
          this._getAlreadyLinkedNum();
        }
      });
    }
  }
  // 防抖函数
  debounce = (fn, delay) => {
    let timer = null;
    return function(...args) {
      if (timer) clearTimeout(timer);
      timer = setTimeout(() => {
        fn.apply(this, args);
      }, delay);
    };
  }

  // 获取表格信息（添加防抖）
  getTable = (() => {
    // 实际执行的函数
    const fetchData = (data, cb) => {
      // 避免重复请求相同参数的数据
      const requestKey = JSON.stringify(data);
      
      // 如果已经在加载中，不重复请求
      if (this.state.loading) return;
      
      this.setState({
        loading: true
      }, () => {
        ajax.findUninsuredPerList(data).then(res => {
          this.setState({
            loading: false
          });
          const { pageNumber, pageSize } = res.data;
          const tableList = res.data.data.map((item, i) => {
            return {
              ...item,
              number: (pageNumber - 1) * pageSize + i + 1
            }
          });
          this.setState({
            tableList,
            pagination: {
              ...this.state.pagination,
              total: res.data.total,
              current: res.data.pageNumber,
              pageSize: res.data.pageSize
            },
            selectedRowKeys: [],
            selectedRows: []
          }, () => {
            cb && cb(res.data);
            this.props.getTotal(res.data.other);
          });
        }).catch(() => {
          this.setState({
            loading: false
          });
        });
      });
    };
    
    // 返回防抖包装后的函数
    return this.debounce(fetchData, 300);
  })()

  // 投保弹窗在线购买保单是否可以勾选
  _canSelectRadio() {
    // 选择人数大于3
    if(this.state.importCount == 0) {
      return this.state.selectedRows.length < 3;
    }else {
      // 导入成功人数大于3
      return this.state.importCount < 3;
    }
  }
  //获取部门树数据
  getDepart = (forceUpdate = false, cb) => {
    // 如果有缓存且不强制更新，则使用缓存
    if (!forceUpdate && Uninsured.cachedData.departments) {
      this.setState({
        treeData: Uninsured.cachedData.departments
      }, () => {
        cb && cb();
      });
      return;
    }

    //获取部门树数据
    ajax.systemComDepartGetTreeDepart().then(
      response => {
        let { data } = response;
        data = JSON.parse(
          JSON.stringify(data).replace(/\"children\":\[\]/g, '"isLeaf":true')
        );
        data.unshift({
          label: '全部',
          value: ''
        });
        
        // 更新缓存
        Uninsured.cachedData.departments = data;
        
        this.setState({
          treeData: data
        }, () => {
          cb && cb();
        });
      },
      err => {
        console.log(err, 'getTreeDepart-选择部门-err');
        // 错误时也调用回调，确保流程继续
        cb && cb();
      }
    );
  }

  getPerType = (forceUpdate = false, cb) => {
    // 如果有缓存且不强制更新，则使用缓存
    if (!forceUpdate && Uninsured.cachedData.perTypes) {
      this.setState({
        perTypeList: Uninsured.cachedData.perTypes,
        perType: Uninsured.cachedData.perTypes[0].codeValue
      }, () => {
        cb && cb();
      });
      return;
    }

    // 获取人员类别
    ajax.getPerType({ codeType: 'perType' }).then(
      response => {
        if (response.data) {
          const firstValue = {
            codeType: "perType",
            codeValue: "",
            label: "全部"
          };
          const perTypeList = [firstValue, ...response.data];
          
          // 更新缓存
          Uninsured.cachedData.perTypes = perTypeList;
          
          this.setState({
            perTypeList,
            perType: perTypeList[0].codeValue
          }, () => {
            cb && cb();
          });
        } else {
          cb && cb();
        }
      },
      err => {
        console.log(err);
        // 错误时也调用回调，确保流程继续
        cb && cb();
      }
    );
  }

  // 移除getProjectList方法，使用父组件传递的props

  /**点击事件 */
  onlineOk = () => {
    const tomorrow = moment().add(1, 'days').format('YYYY-MM-DD');
    const { effectEndDate } = this.state.onlineList.find(value => value.orderId == this.state.onlineOrderId);
    if (effectEndDate < tomorrow) {
      return message.error('该保险今天失效');
    }
    const subData = {
      orderId: this.state.onlineOrderId,
      startTime: tomorrow,
      businessType: this.props.insuranceType === 'temporary' ? 1 : 0
    };
    let apiUrl = 'tempBatchInsPerToAddPreservationService';
    // 导入投保的情况
    if (!!this.state.importBatchId) {
      subData.importBatchId = this.state.importBatchId;
      // 表格中选人的情况
    } else {
      const perIds = this.state.selectedRows.reduce((a, b) => {
        return a + ',' + b.perId;
      }, '').slice(1);
      subData.perIds = perIds;
      apiUrl = 'addPreservationService';
    }
    ajax[apiUrl](subData).then(res => {
      this.setState({
        onlineVisible: false,
        importBatchId: '',
        importCount: 0,
      });
      if(res.data.indexOf('http') !== -1) {
        window.open(res.data);
      }
      Modal.success({
        title: '已完成在线支付',
        okText: '确定',
        content: <p className="modal_tip left0">批改结果预计将在5分钟后更新，
        请注意查看“保全缴费-批改申请记录”状态</p>,
        onOk: () => {
          this.setState({
            modalVisible: false
          });
        }
      });
      this.getTable(this.state.searchData);
    });
  }
  onlineCancel = () => {
    this.setState({
      modalVisible: true,
      onlineVisible: false
    });
  }
  // 获取保单已经关联的人数（添加缓存）
  _getAlreadyLinkedNum = () => {
    const { outlineIndex, outlineList } = this.state;
    if(outlineList.length > 0) {
      const comInsId = outlineList[outlineIndex].comInsId;
      
      // 使用静态缓存存储已查询过的关联人数
      if (!Uninsured.cachedData.linkedNums) {
        Uninsured.cachedData.linkedNums = {};
      }
      
      // 如果缓存中有数据且未过期（10分钟内），直接使用缓存
      const now = new Date().getTime();
      const cachedData = Uninsured.cachedData.linkedNums[comInsId];
      if (cachedData && (now - cachedData.timestamp < 10 * 60 * 1000)) {
        this.setState({
          alreadyLinkedNum: cachedData.count
        });
        return;
      }
      
      // 变化保单已经关联的人数
      ajax.findUnderWarrantyPerListCount({ 
        comInsId,
        tlkProjectId: this.props.tlkProjectId
       }).then(res => {
        // 更新缓存
        Uninsured.cachedData.linkedNums[comInsId] = {
          count: res.data,
          timestamp: now
        };
        
        this.setState({
          alreadyLinkedNum: res.data
        });
      });
    }
  }
  outlineOk = async () => {
    const { selectedRows, outlineIndex, outlineList, alreadyLinkedNum, importBatchId, importCount } = this.state;
    const { comInsId } = outlineList[outlineIndex];
    const subData = {
      comInsId,
      tlkProjectId: this.props.insuranceType === 'temporary' ? this.props.tlkProjectId : undefined
    };
    // 保单已经关联的人数
    const num = alreadyLinkedNum;
    // 保单最多关联人数
    const max = outlineList[outlineIndex].perNum;
    // 当前选中人数
    let selectedNum = importCount;
    // 请求url
    let apiUrl = 'tempBatchInsPerToRelevance';
    // 导入投保
    if (!!this.state.importBatchId) {
      subData.importBatchId = importBatchId;
    } else {  //选中表格人员投保
      selectedNum = selectedRows.length;
      subData.idCards = selectedRows.reduce((a, b) => {
        return a + ',' + b.idCardNo;
      }, '').slice(1);
      apiUrl = 'addBatchRelevancePer';
    }
    if (max <= 0) {
      return Modal.error({
        title: '温馨提示',
        content: `该保险正在审核中`,
        okText: '确定'
      });
    }
    if (num + selectedNum > max) {
      return Modal.error({
        title: '到达保单关联上限！',
        content: <div>
          <p>{
            `保单已经关联${num},最多还可以关联${max - num}人`}
          </p>

          <span style={{ color: '#f5222d' }}>*企业若发生人员变动，请及时前往【保险保单管理】-【修改】上传批单，后台将进行人工校验，以免相关人员无法关联到保单!</span>
        </div>,
        okText: '确定'
      });
    }
    ajax[apiUrl](subData).then(res => {
      this.setState({
        outlineVisible: false,
        importBatchId: '',
        importCount: 0,
        // outlineSuccessModal: true,
        // outlineSuccessTitle: res.msg
      }, () => {
        Modal.confirm({
          title: '上传批单提示',
          content: (<div>
            <p style={{ color: 'red' }}>*企业若发生人员变动，可通过【保险保单管理】-【修改】上传批单，后台将进行人工校验，请务必上传真实有效数据！</p>
            <p>本次成功关联<span style={{ color: 'red' }}>{selectedNum}</span>位，请及时上传相应批单，系统会将投保情况实时向公安机关报备，请保证所有人员均已投保！</p>
          </div>),
          okText: '马上办理',
          cancelText: '取消',
          onOk: () => {
            this.props.history.push(`/insurancemanagement/enterpriseinsurance/insurancedetails?comInsId=${comInsId}&edit=00`);
          },
          onCancel: () => {
            // this.props.changeTabIndex();
          }
        });
        this.getTable(this.state.searchData);
      });
      // Modal.success({
      //   title: res.msg,
      //   okText: '查看该保单',
      //   cancelText: '关闭',
      //   content: <p>已将您的人员关联到对应的保单中，可在“已投保”页面查看。</p>,
      //   onOk:() => {
      //     this.setState({
      //       modalVisible: false,
      //       outlineVisible: false
      //     });
      //     console.log('ok');
      //   },
      //   onCancel:() => {
      //     this.setState({
      //       modalVisible: true,
      //       outlineVisible: false
      //     });
      //   }
      // });
    });
  }
  outlineCancel = () => {
    this.setState({
      modalVisible: true,
      outlineVisible: false
    });
  }

  // 表格渲染
  renderOrderList = () => {
    // 定义基础列
    const baseColumns = [
      {
        title: '序号',
        dataIndex: 'number',
        key: 'number',
        hidden: false
      },
      {
        title: '姓名',
        dataIndex: 'name',
        key: 'name',
        hidden: false
      },
      {
        title: '手机号',
        dataIndex: 'mobilePhone',
        key: 'mobilePhone',
        hidden: false
      },
      {
        title: '部门',
        dataIndex: 'departName',
        key: 'departName',
        hidden: this.state.isLinbao,
        render: (text, record) => {
          if (record.departName) {
            return <span>{record.departName}</span>;
          } else {
            return <span>{this.state.treeData[1]&&this.state.treeData[1].label}</span>;
          }
        }
      },
      {
        title: '身份证号',
        dataIndex: 'idCardNo',
        key: 'idCardNo',
        hidden: false
      },
      {
        title: '入职时间',
        dataIndex: 'entryDate',
        key: 'entryDate',
        hidden: this.state.isLinbao,
      },
      {
        title: '人员类别',
        dataIndex: 'majorGroup',
        key: 'majorGroup',
        hidden: this.state.isLinbao,
      },
      {
        title: '所属项目',
        dataIndex: 'projectName',
        key: 'projectName',
        hidden: !this.state.isLinbao,
      },
      {
        title: '所属企业',
        dataIndex: 'comName',
        key: 'comName',
        hidden: !this.state.isLinbao,
      },
      {
        title: '操作',
        dataIndex: 'operation',
        key: 'operation',
        hidden: false,
        render: (text, record) => (
          this.state.isLinbao ? <></> :
          <div>
            <span
              style={{
                color: '#108EE9',
                cursor: 'pointer',
                marginRight: '20px'
              }}
              onClick={() => {
                this.setState({
                  recoverRows: this.state.selectedRows
                }, () => {
                  this.setState({
                    selectedRows: [record],
                    modalVisible: true
                  });
                });
              }}
            >
              投保
            </span>
          </div>
        )
      }
    ];
    
    // 根据insuranceType决定是否显示入职时间字段
    let columns = baseColumns.filter(item => !item.hidden);
    
    // 如果不是临保保险，则显示入职时间、人员类别字段
    // if (this.props.insuranceType !== 'temporary') {
    //   columns.splice(5, 0, {
    //     title: '入职时间',
    //     dataIndex: 'entryDate',
    //     key: 'entryDate'
    //   },
    //   {
    //     title: '人员类别',
    //     dataIndex: 'majorGroup',
    //     key: 'majorGroup'
    //   },);
    // } else { // 如果是临保保险，则显示所属项目、所属企业字段
    //   columns.splice(5, 0, {
    //     title: '所属项目',
    //     dataIndex: 'projectName',
    //     key: 'projectName'
    //   },
    //   {
    //     title: '所属企业',
    //     dataIndex: 'comName',
    //     key: 'comName'
    //   },

    // );
    // }
    return (
      <div>

        <Table
          // loading={this.state.loading}
          dataSource={this.state.tableList}
          columns={columns}
          pagination={this.state.pagination}
          onChange={(pagination) => {
            const searchData = {  // 搜索数据
              ...this.state.searchData,
              pageNumber: pagination.current,  // 页	
              pageSize: pagination.pageSize
            };
            this.setState({
              searchData
            }, () => {
              this.getTable(searchData);
            });

          }}
          rowSelection={{
            onChange: (selectedRowKeys, selectedRows) => {
              this.setState({
                selectedRows,
                selectedRowKeys
              });
            },
            selectedRowKeys: this.state.selectedRowKeys
          }}
        />
      </div>
    );
  };

  //树选中事件
  treeSelectOnChangeHandler = value => {
    this.setState({ userIdArrays: value });
  };
  render() {
    return (
      <div className="insurance">
        <Alert
          message={<div>当前您的{this.state.isLinbao ? '企业临保项目' : '企业'}人员中有<span style={{ color: '#ff6600' }}>{this.props.total}</span>人暂未购买保险，执行任务时存在风险，请及时为其投保，为企业减轻风险，为员工提供安全保障！<br />系统支持同时500人投保，请先分页选择单页500人，然后全选本页人员进行投保。</div>}
          type="warning"
          showIcon
          style={{ marginBottom: '15px' }}
        />
        <div className="form">
          <label style={{ marginRight: 16 }}>
            关键字：
            <Input
              style={{ width: '214px', marginBottom: '10px' }}
              placeholder="请输入姓名/手机号/身份证"
              onChange={(e) => {
                this.setState({
                  keyword: e.target.value
                });
              }}
              value={this.state.keyword}
              maxLength={20}
            />
          </label>
          { this.state.isLinbao ? 
          (<>
          <label style={{ marginRight: 16 }}>
            所属企业：
            <Input
              style={{ width: '214px', marginBottom: '10px' }}
              placeholder="请输入所属企业"
              onChange={(e) => {
                this.setState({
                  comName: e.target.value
                });
              }}
              value={this.state.comName}
              maxLength={20}
            />
          </label>
          </>) : (<>
            <label style={{ marginRight: 16 }}>
            部门：
            <TreeSelect
              style={{ width: 300 }}
              className="w-400 ipt-h"
              dropdownStyle={{ maxHeight: 250, overflow: 'auto' }}
              treeData={this.state.treeData}
              placeholder="请选择部门"
              treeDefaultExpandAll
              value={this.state.departId}
              // multiple
              defaultValue={this.state.departId}
              onChange={value => {
                // console.log(value);
                this.setState({
                  departId: value
                });
              }}
            />
          </label>
          <label style={{ marginRight: 16 }}>
            人员类别：
            <Select
              style={{ width: 200 }}
              placeholder="请选择"
              onChange={(value) => {
                $log(value, 'green', '人员类别');
                this.setState({
                  perType: value
                });
              }}
              value={this.state.perType}
            // disabled={this.props.companyInfo.industryType === '02' && this.state.perId !== ''}
            >
              {(() => {
                return this.state.perTypeList.map((val, key) => {
                  return (
                    <Option key={key} value={val.codeValue + ''}>
                      {val.label}
                    </Option>
                  );
                });
              })()}
            </Select>
          </label>
          </>)}
          
          <Button
            style={{
              marginRight: '16px',
              marginBottom: '16px',
              padding: window && window.innerWidth <= 1366 ? '0 10px' : '0 15px'
            }}
            type="primary"
            onClick={() => {
              const data = {
                ...this.state.searchData,
                perType: this.state.perType,  //人员类型
                keyword: this.state.keyword,  //关键字
                departId: this.state.departId == '0' ? '' : this.state.departId,  //部门id
                comName: this.state.comName, // 所属企业
                tlkProjectId: this.props.tlkProjectId,
              };
              this.setState({
                searchData: data,
                canExport: true
              });
              this.getTable(data);
            }}
          >
            搜索
          </Button>
          <Button
            onClick={() => {
              this.setState({
                searchData: {
                  perType: '',  //人员类型
                  keyword: '',  //关键字
                  departId: '',  //部门id
                  pageNumber: '1',  // 页	
                  pageSize: '10',  //条目
                  businessType: this.props.insuranceType === 'temporary' ? 1 : 0, 
                  comName: '', // 所属企业
                  tlkProjectId: this.props.tlkProjectId || '*****',
                }
              }, () => {
                this.setState({
                  ...this.state.searchData,
                });
                this.getTable(this.state.searchData);
              });
            }}
            style={{
              padding: window && window.innerWidth <= 1366 ? '0 10px' : '0 15px'
            }}
          >
            重置
          </Button>
        </div>
        <div className="receive-list">
          <div className="receive-row">
            <Popover content={
              <div style={{ padding: '5px 10px' }}>
                <p style={{ margin: 0 }}>请勾选内容</p>
              </div>
            }>
              <Button type="primary"
                onClick={() => {
                  this.state.selectedRows.length > 0 && this.setState({
                    modalVisible: true,
                    importBatchId: '',
                    importCount: 0
                  });
                }}
              >
                批量购买保险
              </Button>
            </Popover>
            {/*发送信息弹窗*/}
            <Button
              style={{ marginLeft: 15 }}
              type="primary"
              onClick={() => {
                // 重置为默认值，打开弹窗
                this.setState({
                  importBatchId: '',
                  importCount: 0,
                  bulkVisible: true
                });
              }}>导入投保</Button>
              
            <Popover content={<div style={{padding: 10}}>搜索后可导出</div>}>
              {/* <ExcelButtonOline
                disabled={!this.state.canExport}
                method="POST"
                style={{ marginLeft: "15px" }}
                params={this.state.searchData}
                apiurl={"/enterprise/ins/com-ins/export-uninsured-per-list"}
                downloadname={this.props.global.companyInfo.comName + "_未投保人员"}
              >
                导出筛选结果为excel
              </ExcelButtonOline> */}
              {
                excelButtonHOC({
                  disabled:!this.state.canExport,
                  method: 'POST',
                  style: { marginLeft: "15px" },
                  params: this.state.searchData,
                  apiurl: "/enterprise/ins/com-ins/export-uninsured-per-list",
                  downloadname: this.props.global.companyInfo.comName + "_未投保人员",
                  children: '导出筛选结果为excel'
                }, Button)
              }
            </Popover>
            {/* <Button onClick={() => {
              log('filter')
            }}>批量设置为过滤</Button> */}
          </div>
        </div>
        {this.renderOrderList()}
        {/*查看信息弹窗1*/}
        {/* <MessageDetail
          record={this.state.record}
          visible={this.state.checkModal}
          closeModal={() => {
            this.setState({ checkModal: false });
            this.search();
          }}
        /> */}

        {/* 批量购买弹窗内容 */}
        <Modal
          title={
            this.state.importCount == 0? 
            `投保(已选择${this.state.selectedRows.length}人)`:
            `投保(已导入${this.state.importCount}人)`
          }
          maskClosable={true}
          visible={this.state.modalVisible}
          onOk={() => {
            switch (this.state.radio) {
              case '0':
                // 未选
                message.error('请选择选项');
                break;
              case '1':
                // 在线购买保单
                log(this.state.importBatchId);
                // 导入投保
                const { importBatchId } = this.state;
                if (!!importBatchId) {
                  ajax.getCompnayAndTempBatchInsPerPutCache({ 
                    importBatchId,
                    businessType: this.props.insuranceType === 'temporary' ? 1 : 0,
                    tlkProjectId: this.props.tlkProjectId,
                   }).then(res => {
                    this.props.history.push({
                      pathname:
                        '/insurancemart',
                      search: `?url=${encodeURIComponent(res.data)}`
                    });
                  });
                  // 表格中选人投保
                } else {
                  const perIds = this.state.selectedRows.reduce((a, b) => {
                    return a + ',' + b.perId;
                  }, '').slice(1);
                  ajax.getCompnayAndPersonPutCacheLink({
                    perIds,
                    businessType: this.props.insuranceType === 'temporary' ? 1 : 0,
                    tlkProjectId: this.props.tlkProjectId,
                  }).then(data => {
                    log("data", data);
                    this.props.history.push({
                      pathname:
                        '/insurancemart',
                      search: `?url=${encodeURIComponent(data.data)}`
                    });
                  });
                }
                break;
              case '2':
                // 将人员增员到已有的保险保单中
                // 表格中选人的时候判断是否大于100人
                if (!this.state.importBatchId && this.state.selectedRows.length > 100) {
                  notification.error({
                    message: '一次最多关联100人'
                  });
                } else {
                  this.setState({
                    modalVisible: false,
                    onlineVisible: true
                  });
                }
                this.getOnlinePolicyData(true); // 强制更新线上保单数据
                break;
              case '3':
                // 关联已有线下保单
                this.setState({
                  modalVisible: false,
                  outlineVisible: true
                });
                this.getOutlinePolicyData(true); // 强制更新线下保单数据
            }

          }}
          onCancel={() => {
            if(!!this.state.importBatchId) {
              this.setState({
                modalVisible: false,
                bulkVisible: true
              });
            }else {
              if (this.state.recoverRows.length > 0) {
                this.setState({
                  selectedRows: JSON.parse(JSON.stringify(this.state.recoverRows))
                }, () => {
                  this.setState({
                    recoverRows: []
                  });
                });
              }
              this.setState({
                modalVisible: false
              });
            }
          }}
        >
          <RadioGroup
            onChange={(e) => {
              this.setState({
                radio: e.target.value
              });
            }}
            value={this.state.radio}
          >
            <Radio value="1" disabled={this._canSelectRadio()}>
              <span>暂无保单，直接在线购买新保单。（至少选择3人）</span>
              <p className="modal_tip">为人员购买新的保险保单。</p>
            </Radio>
            {
              !this.state.isLinbao && (
                <Radio value="2">
                  <span>查看已有线上保单，发起增员批单申请。</span>
                  <p className="modal_tip">将人员增员到已有的保险保单中(一次最多关联100个人)</p>
                </Radio>
              )
            }
            <Radio value="3">
              <span>关联已有线下保单</span>
              <p className="modal_tip">若该人员已有线下保险保单，则请关联投保状态。</p>
            </Radio>
          </RadioGroup>
        </Modal>

        {/* 关联线上保单模态框 */}

        <Modal
          className="insurance_modal"
          title="关联已有线上保单"
          visible={this.state.onlineVisible}
          onOk={this.onlineOk}
          onCancel={this.onlineCancel}
          footer={[
            <Button key="取消" onClick={this.onlineCancel}>取消</Button>,
            <Button disabled={this.state.onlineList.length == 0} key="关联" type="primary" onClick={this.onlineOk}>
              关联
            </Button>
          ]}
        >
          {
            this.state.onlineList.length == 0 && <Alert
              message={<div>暂无线上保单</div>}
              type="warning"
              showIcon
              style={{ marginBottom: '15px' }}
            />
          }
          {
            this.state.onlineList.length > 0 && (
              <div>
                <div className="insurance_item">
                  <p className="label">请选择需要关联的线上保单：</p>
                  <Select defaultValue={0} onChange={(value) => {
                    const onlineOrderId = this.state.onlineList[value].orderId;
                    this.setState({
                      onlineOrderId
                    });
                  }}>
                    {this.state.onlineList.map((item, index) => {
                      return (
                        <Option key={index} value={index}>{item.label}</Option>
                      );
                    })}
                  </Select>
                </div>
                <div className="insurance_item">
                  <p className="label">保障生效时间：</p>
                  <DatePicker defaultValue={moment().add(1, 'days')} disabled onChange={(value, dateString) => {

                    console.log('Formatted Selected Time: ', dateString);
                  }} format={'YYYY-MM-DD'} />
                </div>
                <p className="modal_tip left0">注：关联线上保单时，需要等待保险公司审核，请在<a>批单申请记录中</a>查看进度。</p>
              </div>
            )
          }

        </Modal>




        {/* 关联线下保单模态框 */}
        <Modal
          className="insurance_modal"
          title="关联已有线下保单"
          visible={this.state.outlineVisible}
          onOk={this.outlineOk}
          onCancel={this.outlineCancel}
          footer={[
            <Button key="取消" onClick={this.outlineCancel}>取消</Button>,
            <Button
              disabled={this.state.outlineList.length == 0}
              key="关联" type="primary" onClick={this.outlineOk}>
              关联
            </Button>
          ]}
        >
          {
            this.state.outlineList.length == 0 && <Alert
              message={<div>暂无线下保单</div>}
              type="warning"
              showIcon
              style={{ marginBottom: '15px' }}
            />
          }
          {
            this.state.outlineList.length > 0 && (
              <div className="insurance_item">
                <p className="label">请选择需要关联的线下保单：</p>
                <Select defaultValue={0} onChange={(value) => {
                  this.setState({
                    outlineIndex: value
                  }, () => {
                    this._getAlreadyLinkedNum();
                  });
                }}>
                  {this.state.outlineList.map((item, index) => {
                    return (
                      <Option key={index} value={index}>{item.label}</Option>
                    );
                  })}
                </Select>
              </div>
            )
          }
          {this.state.outlineList[this.state.outlineIndex] && (
            <div>
              <div className="item_detail">
                <span>保单号：{this.state.outlineList[this.state.outlineIndex].policyNo}</span>
              </div>
              <div className="item_detail">
                <span>产品名称：{this.state.outlineList[this.state.outlineIndex].productName}</span>
              </div>
              <div className="item_detail">
                <span>保险公司：{this.state.outlineList[this.state.outlineIndex].insComName}</span>
              </div>
              <div className="item_detail">
                <span>当前在保人数：{this.state.alreadyLinkedNum}/{this.state.outlineList[this.state.outlineIndex].perNum}</span>
              </div>
            </div>
          )}
        </Modal>


        <Modal
          visible={this.state.outlineSuccessModal}
          okText="查看已投保"
          cancelText="关闭"
          closable={false}
          title={<div><Icon type="check-circle" theme="twoTone" twoToneColor="#52c41a" /><span style={{ marginLeft: 10 }}>{this.state.outlineSuccessTitle}</span></div>}
          onCancel={() => {
            this.setState({
              outlineSuccessModal: false,
              modalVisible: false,
              outlineSuccessTitle: ''
            });
          }}
          onOk={() => {
            // const {outlineIndex,outlineList} = this.state;
            // const comInsId = outlineList[outlineIndex].comInsId;
            // this.props.history.push({
            //   pathname: `/insurancemanagement/enterpriseinsurance/insurancedetails&edit=00`,
            //   search: `?comInsId=${comInsId}`
            // });
            this.props.changeTabIndex();
            this.setState({
              outlineSuccessModal: false,
              modalVisible: false,
              outlineSuccessTitle: ''
            });
          }}
        >
          <p style={{ marginLeft: 25 }}>已将您的人员关联到对应的保单中，可在“已投保”页面查看。</p>
        </Modal>


        {/* 导入投保 */}
        <BulkInsuranceModal
          visible={this.state.bulkVisible}
          importCount={this.state.importCount}
          importBatchId={this.state.importBatchId}  //批次id
          setParentState={this.setState.bind(this)}
          insuranceType={this.props.insuranceType}
          tlkProjectId={this.props.tlkProjectId}
        />
      </div>
    );
  }
}