/**
 * 切换地图按钮
 */
import React, { Component } from 'react';
import { Row, Col, Popover, Tooltip } from "antd";
import { connect } from "dva";
import ReactDom from 'react-dom';
@connect((state) => ({
  policeData: state.command.policeData,
  mapStyle: state.command.mapStyle,
  layoutAuthority: state.command.layoutAuthority,
}))
export default class SwitchMap extends Component {
  constructor(props) {
    super(props);
    this.state = {
      layerStatus: props.layerStatus,
      visible: false,
      mapList: []
    };
  }

  componentDidMount() {
  }
  componentWillReceiveProps(nextProps) {
    if (nextProps.layerStatus !== this.state.layerStatus) {
      //如果当前是警保联动图层，被切换后，要先清除当前警保联动图层的打点数据
      switch (this.state.layerStatus) {
        case 'police':
          //清空警报联动的所有打点信息
          if (this.props.policeData.tab1 || this.props.policeData.tab2) {
            var allMarks = []
            if (this.props.policeData.tab1) {
              for (let key in this.props.policeData.tab1) {
                allMarks = allMarks.concat(this.props.policeData.tab1[key])
              }
            }
            if (this.props.policeData.tab2) {
              for (let key in this.props.policeData.tab2) {
                allMarks = allMarks.concat(this.props.policeData.tab2[key])
              }
            }
            this.props._thisGIS.state.policeMap.remove(allMarks)
            this.props.dispatch({
              type: "command/fetchPoliceData",
              payload: {
                options: 'clear'
              },
            });
          }
          break;
      }
      this.setState({
        layerStatus: nextProps.layerStatus
      });
    }
  }
  hide = () => {
    this.setState({
      visible: false,
    });
  };
  _handleVisibleChange = visible => {
    this.setState({ visible });
  };
  _onSwitch(param) {
    const { onSwitchMap } = this.props;
    this.hide()
    onSwitchMap && onSwitchMap(param);
  }
  render() {
    const { layerStatus } = this.state
    const { mapStyle, layoutAuthority } = this.props
    const content = (
      <div>
        {
          layoutAuthority.attendanceMapShow == '是' && <div className={layerStatus == 'attendance' ? 'map-switch selectedMap' : 'map-switch'} onClick={this._onSwitch.bind(this, 'attendance')}>{layoutAuthority.basisLayer ? layoutAuthority.basisLayerName : layoutAuthority.defaultLayerName}</div>
        }
        {/* {
          layoutAuthority.personMapShow == '是' && <div className={layerStatus == 'person' ? 'map-switch selectedMap' : 'map-switch'} onClick={() => {
            this.switch('person')
          }}>三维信息</div>
        } */}
        {
          layoutAuthority.aPictureMapShow == '是' && <div className={layerStatus == 'aPicture' ? 'map-switch selectedMap' : 'map-switch'} onClick={this._onSwitch.bind(this, 'aPicture')}>{layoutAuthority.customLayerName}</div>
        }
        {/* {
          layoutAuthority.policeMapShow == '是' && <div className={layerStatus == 'police' ? 'map-switch selectedMap' : 'map-switch'} onClick={() => {
            this.switch('police')
          }}>{layoutAuthority.basisLayerName}</div>
        } */}
        {
          layoutAuthority.additionalLayer == '是' && layoutAuthority.additionalType=='南宁海康押运' && <div className={layerStatus == 'nanNing' ? 'map-switch selectedMap' : 'map-switch'} onClick={this._onSwitch.bind(this, 'nanNing')}>{layoutAuthority.additionalName?layoutAuthority.additionalName:'南宁武装押运管控'}</div>
        }
      </div>
    );
    return (
      <div className="switch map">
        <Tooltip title="图层切换">
          <div className="layer-btn">
            <Popover
                placement="bottom"
                content={content}
                title=""
                trigger="click"
                visible={this.state.visible}
                onVisibleChange={this._handleVisibleChange}
              >
                <img
                  className="layer-img"
                  src={
                    this.state.visible
                      ? require("@assets/images/prevention/map1-click.png") :
                      mapStyle == 'dark' ? require("@assets/images/prevention/map1-white.png")
                        : require("@assets/images/prevention/map1.png")
                  }
                ></img>
              </Popover>
          </div>
        </Tooltip>
      </div>
    );
  }
}
